/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OS {
    Windows,
    macOS,
    Linux,
    FreeBSD,
    Other;

    public static final OS CURRENT;

    @NotNull
    public static OS fromString(@Nullable String os) {
        if (os != null) {
            if ((os = os.toLowerCase(Locale.ENGLISH)).startsWith("windows")) {
                return Windows;
            }
            if (os.startsWith("mac")) {
                return macOS;
            }
            if (os.startsWith("linux")) {
                return Linux;
            }
            if (os.startsWith("freebsd")) {
                return FreeBSD;
            }
        }
        return Other;
    }

    static {
        CURRENT = OS.fromString(System.getProperty("os.name"));
    }
}

