/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

@ApiStatus.Internal
public class DefaultPicoContainer
implements MutablePicoContainer {
    private final DefaultPicoContainer parent;
    private final Map<Object, ComponentAdapter> componentKeyToAdapter = new ConcurrentHashMap<Object, ComponentAdapter>();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();

    public DefaultPicoContainer(@Nullable DefaultPicoContainer parent) {
        this.parent = parent;
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @NotNull
    public final Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public final void release() {
        this.componentKeyToAdapter.clear();
        this.componentAdapters.clear();
    }

    @Nullable
    private ComponentAdapter getFromCache(@NotNull Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapter.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        return componentKey instanceof Class ? this.componentKeyToAdapter.get(((Class)componentKey).getName()) : null;
    }

    @Nullable
    public final ComponentAdapter getComponentAdapterOfType(@NotNull Class<?> componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @NotNull
    public final List<ComponentAdapter> getComponentAdaptersOfType(@NotNull Class<?> componentType) {
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.componentKeyToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        for (ComponentAdapter adapter : this.componentKeyToAdapter.values()) {
            Class<?> descendant;
            if (adapter.getComponentKey() instanceof String || componentType != (descendant = adapter.getComponentImplementation()) && !componentType.isAssignableFrom(descendant)) continue;
            result.add(adapter);
        }
        return result;
    }

    public final ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (this.componentKeyToAdapter.putIfAbsent(componentAdapter.getComponentKey(), componentAdapter) != null) {
            throw new PicoRegistrationException("Key " + componentAdapter.getComponentKey() + " duplicated");
        }
        this.componentAdapters.add(componentAdapter);
        return componentAdapter;
    }

    @Override
    @Nullable
    public final ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapter.remove(componentKey);
        if (adapter == null) {
            return null;
        }
        this.componentAdapters.remove(adapter);
        return adapter;
    }

    @Override
    @Nullable
    public Object getComponentInstance(@NotNull Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return adapter.getComponentInstance(this);
        }
        return this.parent == null ? null : this.parent.getComponentInstance(componentKey);
    }

    @Nullable
    public final <T> T getService(@NotNull Class<T> serviceClass) {
        ComponentAdapter adapter = this.componentKeyToAdapter.get(serviceClass.getName());
        if (adapter == null) {
            return null;
        }
        return (T)adapter.getComponentInstance(this);
    }

    @ApiStatus.Internal
    @Nullable
    public final ComponentAdapter getServiceAdapter(@NotNull String key) {
        return this.componentKeyToAdapter.get(key);
    }

    @Override
    @Nullable
    public final Object getComponentInstanceOfType(@NotNull Class<?> componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (this.componentAdapters.getImmutableSet().contains(componentAdapter)) {
            return componentAdapter.getComponentInstance(this);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public final ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    @Override
    public final ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class<?> componentImplementation) {
        return this.registerComponent(new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation));
    }

    public final DefaultPicoContainer getParent() {
        return this.parent;
    }

    public final String toString() {
        DefaultPicoContainer parent = this.parent;
        return "DefaultPicoContainer" + (parent == null ? " (root)" : " (parent=" + parent + ")");
    }

    public static final class InstanceComponentAdapter
    implements ComponentAdapter {
        private final Object componentKey;
        private final Object componentInstance;

        public InstanceComponentAdapter(@NotNull Object componentKey, @NotNull Object componentInstance) {
            this.componentKey = componentKey;
            this.componentInstance = componentInstance;
        }

        @Override
        public Object getComponentInstance(PicoContainer container) {
            return this.componentInstance;
        }

        @Override
        public Object getComponentKey() {
            return this.componentKey;
        }

        @Override
        public Class<?> getComponentImplementation() {
            return this.componentInstance.getClass();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getComponentKey() + "]";
        }
    }

    private static final class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                if (this.immutableSet != null) {
                    this.immutableSet = null;
                }
                this.synchronizedSet = new LinkedHashSet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> result = this.immutableSet;
            if (result == null) {
                Object object = this.lock;
                synchronized (object) {
                    result = this.immutableSet;
                    if (result == null) {
                        this.immutableSet = result = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            return result;
        }
    }
}

