/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;
    private final boolean myImmediateDelivery;

    public Topic(@NonNls @NotNull String name, @NotNull Class<L> listenerClass) {
        this(name, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NotNull Class<L> listenerClass) {
        this(listenerClass.getSimpleName(), listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        this(listenerClass.getSimpleName(), listenerClass, broadcastDirection);
    }

    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection, boolean immediateDelivery) {
        this.myDisplayName = listenerClass.getSimpleName();
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.myImmediateDelivery = immediateDelivery;
    }

    public Topic(@NonNls @NotNull String name, @NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        this.myDisplayName = name;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.myImmediateDelivery = false;
    }

    @NonNls
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @NotNull
    public Class<L> getListenerClass() {
        return this.myListenerClass;
    }

    public String toString() {
        return "Topic(name='" + this.myDisplayName + '\'' + ", listenerClass=" + this.myListenerClass + ", broadcastDirection=" + (Object)((Object)this.myBroadcastDirection) + ", immediateDelivery=" + this.myImmediateDelivery + ')';
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        return new Topic<L>(displayName, listenerClass);
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection direction) {
        return new Topic<L>(displayName, listenerClass, direction);
    }

    @NotNull
    public BroadcastDirection getBroadcastDirection() {
        return this.myBroadcastDirection;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public boolean isImmediateDelivery() {
        return this.myImmediateDelivery;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        TO_DIRECT_CHILDREN,
        NONE,
        TO_PARENT;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface ProjectLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface AppLevel {
    }
}

