/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.loader;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class NativeLibraryLoader {
    public static void loadPlatformLibrary(@NotNull String libName) {
        String libFileName;
        Path libFile;
        String baseName = libName;
        if (CpuArch.isIntel64()) {
            baseName = baseName.replace("32", "") + "64";
        }
        if ((libFile = PathManager.findBinFile(libFileName = System.mapLibraryName(baseName).replace(".jnilib", ".dylib"))) == null) {
            File libDir = new File(PathManager.getBinPath());
            throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
        }
        System.load(libFile.toString());
    }
}

