/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JarLoader
implements Loader {
    private static final Map.Entry<Attribute, Attributes.Name>[] PACKAGE_FIELDS = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.CLASS_PATH, Attributes.Name.CLASS_PATH), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR)};
    final ClassPath configuration;
    final URL url;
    final ResourceFile zipFile;
    private final Path path;

    JarLoader(@NotNull Path path, @NotNull ClassPath configuration, @NotNull ResourceFile zipFile) throws IOException {
        this.path = path;
        this.configuration = configuration;
        this.zipFile = zipFile;
        this.url = new URL("jar", "", -1, JarLoader.fileToUri(path) + "!/");
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean containsName(String name) {
        return true;
    }

    @Override
    @Nullable
    public Class<?> findClass(String fileName, String className, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        return this.zipFile.findClass(fileName, className, this, classConsumer);
    }

    @NotNull
    private static URI fileToUri(@NotNull Path file2) {
        String path = file2.toString().replace(File.separatorChar, '/');
        if (!path.startsWith("/")) {
            path = '/' + path;
        } else if (path.startsWith("//")) {
            path = "//" + path;
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    @NotNull
    static Map<Attribute, String> getAttributes(@NotNull Attributes attributes) {
        if (attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<Attribute, String> map = null;
        for (Map.Entry<Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value = attributes.getValue(p.getValue());
            if (value == null) continue;
            if (map == null) {
                map = new EnumMap<Attribute, String>(Attribute.class);
            }
            map.put(p.getKey(), value);
        }
        return map == null ? Collections.emptyMap() : map;
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name) {
        try {
            return this.zipFile.getResource(name, this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        this.zipFile.processResources(dir, fileNameFilter, consumer);
    }

    public String toString() {
        return "JarLoader(path=" + this.path + ")";
    }

    static enum Attribute {
        SPEC_TITLE,
        SPEC_VERSION,
        SPEC_VENDOR,
        CLASS_PATH,
        IMPL_TITLE,
        IMPL_VERSION,
        IMPL_VENDOR;

    }
}

