/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ByteBufferCleaner;
import com.intellij.util.lang.ImmutableZipEntry;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.ZipFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.xxh3.Xxh3;

@ApiStatus.Internal
public final class HashMapZipFile
implements ZipFile {
    private final ImmutableZipEntry[] nameMap;
    private final ImmutableZipEntry[] entries;
    ByteBuffer mappedBuffer;
    final int fileSize;

    private HashMapZipFile(ImmutableZipEntry[] nameMap, ImmutableZipEntry[] entries, ByteBuffer mappedBuffer, int fileSize) {
        this.mappedBuffer = mappedBuffer;
        this.fileSize = fileSize;
        this.nameMap = nameMap;
        this.entries = entries;
    }

    @NotNull
    public static HashMapZipFile load(@NotNull Path file2) throws IOException {
        return (HashMapZipFile)ImmutableZipFile.load(file2, true);
    }

    @NotNull
    static HashMapZipFile createHashMapZipFile(@NotNull ByteBuffer buffer, int fileSize, int entryCount, int centralDirSize, int centralDirPosition) throws EOFException {
        int entrySetLength;
        ImmutableZipEntry[] entrySet;
        int fileEntryCount;
        ImmutableZipEntry[] entries;
        if (entryCount == 65535) {
            entryCount = centralDirPosition / 47;
        }
        if ((entries = new ImmutableZipEntry[entryCount]).length != (fileEntryCount = HashMapZipFile.readCentralDirectory(buffer, centralDirPosition, centralDirSize, entrySet = new ImmutableZipEntry[entrySetLength = entryCount * 2], entries))) {
            ImmutableZipEntry[] resizedEntries = new ImmutableZipEntry[fileEntryCount];
            System.arraycopy(entries, 0, resizedEntries, 0, fileEntryCount);
            entries = resizedEntries;
        }
        buffer.clear();
        return new HashMapZipFile(entrySet, entries, buffer, fileSize);
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        int minNameLength = dir.length() + 2;
        for (ImmutableZipEntry entry : this.entries) {
            String name = entry.getName();
            if (name.length() < minNameLength || name.charAt(dir.length()) != '/' || !name.startsWith(dir) || !nameFilter.test(name)) continue;
            try (InputStream stream = entry.getInputStream(this);){
                consumer.accept(name, stream);
            }
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream(@NotNull String path) throws IOException {
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getInputStream(this);
    }

    @Override
    public byte @Nullable [] getData(@NotNull String path) throws IOException {
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getData(this);
    }

    @Override
    public ByteBuffer getByteBuffer(@NotNull String path) throws IOException {
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getByteBuffer(this);
    }

    @Override
    @Nullable
    public ZipFile.ZipResource getResource(String name) {
        final ImmutableZipEntry entry = this.getRawEntry(name);
        if (entry == null) {
            return null;
        }
        return new ZipFile.ZipResource(){

            @Override
            @NotNull
            public String getPath() {
                return entry.name;
            }

            @Override
            public int getUncompressedSize() {
                return entry.uncompressedSize;
            }

            @Override
            @NotNull
            public ByteBuffer getByteBuffer() throws IOException {
                return entry.getByteBuffer(HashMapZipFile.this);
            }

            @Override
            public byte @NotNull [] getData() throws IOException {
                return entry.getData(HashMapZipFile.this);
            }

            @Override
            @NotNull
            public InputStream getInputStream() throws IOException {
                return entry.getInputStream(HashMapZipFile.this);
            }
        };
    }

    @Nullable
    public ImmutableZipEntry getRawEntry(String name) {
        int index = HashMapZipFile.probe(name, Xxh3.hash(name), this.nameMap);
        return index < 0 ? null : this.nameMap[index];
    }

    public ImmutableZipEntry[] getEntries() {
        return this.entries;
    }

    public ImmutableZipEntry[] getRawNameSet() {
        return this.nameMap;
    }

    private static int readCentralDirectory(ByteBuffer buffer, int centralDirPosition, int centralDirSize, ImmutableZipEntry[] entrySet, ImmutableZipEntry[] entries) throws EOFException {
        int commentLength;
        int extraFieldLength;
        int nameLengthInBytes;
        int entryIndex = 0;
        byte[] tempNameBytes = new byte[4096];
        ImmutableZipEntry prevEntry = null;
        int prevEntryExpectedDataOffset = -1;
        int endOffset = centralDirPosition + centralDirSize;
        for (int offset = centralDirPosition; offset < endOffset; offset += nameLengthInBytes + extraFieldLength + commentLength) {
            ImmutableZipEntry entry;
            int extraSuffixLength;
            if (buffer.getInt(offset) != 33639248) {
                throw new EOFException("Expected central directory size " + centralDirSize + " but only at " + offset + " no valid central directory file header signature");
            }
            int compressedSize = buffer.getInt(offset + 20);
            int uncompressedSize = buffer.getInt(offset + 24);
            int headerOffset = buffer.getInt(offset + 42);
            byte method = (byte)(buffer.getShort(offset + 10) & 0xFFFF);
            nameLengthInBytes = buffer.getShort(offset + 28) & 0xFFFF;
            extraFieldLength = buffer.getShort(offset + 30) & 0xFFFF;
            commentLength = buffer.getShort(offset + 32) & 0xFFFF;
            if (prevEntry != null && prevEntryExpectedDataOffset == headerOffset - prevEntry.compressedSize) {
                prevEntry.setDataOffset(prevEntryExpectedDataOffset);
            }
            buffer.position(offset += 46);
            if (buffer.get(offset + nameLengthInBytes - 1) == 47) {
                uncompressedSize = -2;
                compressedSize = -2;
                extraSuffixLength = 1;
            } else {
                extraSuffixLength = 0;
            }
            buffer.get(tempNameBytes, 0, nameLengthInBytes);
            String name = new String(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength, StandardCharsets.UTF_8);
            int entrySetIndex = HashMapZipFile.probe(name, Xxh3.hash(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength), entrySet);
            if (entrySetIndex >= 0) {
                prevEntry = null;
                continue;
            }
            prevEntry = entry = new ImmutableZipEntry(name, compressedSize, uncompressedSize, headerOffset, nameLengthInBytes, method);
            prevEntryExpectedDataOffset = headerOffset + 30 + nameLengthInBytes + extraFieldLength;
            entrySet[-(entrySetIndex + 1)] = entry;
            entries[entryIndex++] = entry;
        }
        return entryIndex;
    }

    private static int probe(String key, long keyHash, ImmutableZipEntry[] set) {
        int index = (int)(((long)((int)keyHash) & 0xFFFFFFFFL) * (long)set.length >>> 32);
        ImmutableZipEntry found;
        while ((found = set[index]) != null) {
            if (key.equals(found.name)) {
                return index;
            }
            if (++index != set.length) continue;
            index = 0;
        }
        return -index - 1;
    }

    @Override
    public void close() throws Exception {
        ByteBuffer buffer = this.mappedBuffer;
        if (buffer != null) {
            this.mappedBuffer = null;
            ByteBufferCleaner.unmapBuffer(buffer);
        }
    }
}

