/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.DirectByteBufferPool;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.StrippedLongArrayList;
import com.intellij.util.lang.Xor16;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.xxh3.Xx3UnencodedString;

final class FileLoader
implements Loader {
    private static final EnumSet<StandardOpenOption> READ_OPTIONS = EnumSet.of(StandardOpenOption.READ);
    private static final EnumSet<StandardOpenOption> WRITE_OPTIONS = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;
    private static final short indexFileVersion = 24;
    @NotNull
    private final Predicate<? super String> nameFilter;
    @NotNull
    private final Path path;

    FileLoader(@NotNull Path path) {
        this.path = path;
        this.nameFilter = __ -> true;
    }

    private FileLoader(@NotNull Path path, @NotNull Predicate<? super String> nameFilter) {
        this.path = path;
        this.nameFilter = nameFilter;
    }

    @NotNull
    static FileLoader createCachingFileLoader(Path file2, @Nullable CachePoolImpl cachePool, Predicate<? super Path> cachingCondition, boolean isClassPathIndexEnabled, ClasspathCache cache) {
        if (cachePool == null) {
            LoaderData data = FileLoader.buildData(file2, isClassPathIndexEnabled);
            FileLoader loader = new FileLoader(file2, data.nameFilter);
            cache.applyLoaderData(data, loader);
            return loader;
        }
        ClasspathCache.IndexRegistrar data = cachePool.loaderIndexCache.get(file2);
        if (data == null) {
            LoaderData loaderData = FileLoader.buildData(file2, isClassPathIndexEnabled);
            FileLoader loader = new FileLoader(file2, loaderData.nameFilter);
            if (cachingCondition != null && cachingCondition.test(file2)) {
                cachePool.loaderIndexCache.put(file2, loaderData);
            }
            cache.applyLoaderData(loaderData, loader);
            return loader;
        }
        FileLoader loader = new FileLoader(file2, data.getNameFilter());
        cache.applyLoaderData(data, loader);
        return loader;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.path.resolve(dir));){
            for (Path childPath : paths) {
                String name = this.path.relativize(childPath).toString();
                if (!fileNameFilter.test(name) || !Files.isRegularFile(childPath, new LinkOption[0])) continue;
                try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(childPath, new OpenOption[0]));){
                    consumer.accept(name, stream);
                }
            }
        }
        catch (NoSuchFileException | NotDirectoryException fileSystemException) {
            // empty catch block
        }
    }

    private static void buildPackageAndNameCache(Path startDir, ClasspathCache.LoaderDataBuilder context, StrippedLongArrayList nameHashes) {
        Path dir;
        ArrayDeque<Path> dirCandidates = new ArrayDeque<Path>();
        dirCandidates.add(startDir);
        int rootDirAbsolutePathLength = startDir.toString().length();
        while ((dir = (Path)dirCandidates.pollFirst()) != null) {
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);
                try {
                    boolean containsClasses = false;
                    boolean containsResources = false;
                    for (Path file2 : dirStream) {
                        String path = FileLoader.getRelativeResourcePath(file2.toString(), rootDirAbsolutePathLength);
                        if (path.endsWith(".class")) {
                            nameHashes.add(Xx3UnencodedString.hashUnencodedString(path));
                            containsClasses = true;
                            continue;
                        }
                        nameHashes.add(Xx3UnencodedString.hashUnencodedString(path));
                        containsResources = true;
                        if (path.endsWith(".svg") || path.endsWith(".png") || path.endsWith(".xml")) continue;
                        dirCandidates.addLast(file2);
                    }
                    if (!containsClasses && !containsResources) continue;
                    String relativeResourcePath = FileLoader.getRelativeResourcePath(dir.toString(), rootDirAbsolutePathLength);
                    if (containsClasses) {
                        context.addClassPackage(relativeResourcePath);
                    }
                    if (!containsResources) continue;
                    context.addResourcePackage(relativeResourcePath);
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (NoSuchFileException | NotDirectoryException dirStream) {
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @NotNull
    private static String getRelativeResourcePath(@NotNull String path, int startPathLength) {
        String relativePath = path.substring(startPathLength).replace(File.separatorChar, '/');
        return relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name) {
        Path file2 = this.path.resolve(name);
        return Files.exists(file2, new LinkOption[0]) ? new FileResource(file2) : null;
    }

    @Override
    @Nullable
    public Class<?> findClass(String fileName, String className, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        byte[] data;
        Path file2 = this.path.resolve(fileName);
        try {
            data = Files.readAllBytes(file2);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        return classConsumer.consumeClassData(className, data, (Loader)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static LoaderData readFromIndex(Path index) {
        long started = System.nanoTime();
        boolean isOk = false;
        int version = -1;
        try (SeekableByteChannel channel = Files.newByteChannel(index, READ_OPTIONS, new FileAttribute[0]);){
            ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate((int)channel.size());
            try {
                do {
                    channel.read(buffer);
                } while (buffer.hasRemaining());
                buffer.flip();
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                version = buffer.getShort();
                if (version == 24) {
                    long[] classPackageHashes = new long[buffer.getInt()];
                    long[] resourcePackageHashes = new long[buffer.getInt()];
                    LongBuffer longBuffer = buffer.asLongBuffer();
                    longBuffer.get(classPackageHashes);
                    longBuffer.get(resourcePackageHashes);
                    buffer.position(buffer.position() + longBuffer.position() * 8);
                    LoaderData loaderData = new LoaderData(resourcePackageHashes, classPackageHashes, new NameFilter(new Xor16(buffer)));
                    isOk = true;
                    LoaderData loaderData2 = loaderData;
                    return loaderData2;
                }
            }
            finally {
                DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            }
        }
        catch (NoSuchFileException ignore) {
            isOk = true;
        }
        catch (Exception e) {
            System.err.println("Cannot read classpath index (version=" + version + ", module=" + index.getParent().getFileName() + ")");
            e.printStackTrace();
        }
        finally {
            if (!isOk) {
                try {
                    Files.deleteIfExists(index);
                }
                catch (IOException ignore) {}
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveIndex(@NotNull LoaderData data, @NotNull Path indexFile) throws IOException {
        long started = System.nanoTime();
        ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate(2 + data.approximateSizeInBytes());
        try {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)24);
            data.save(buffer);
            assert (buffer.remaining() == 0);
            buffer.flip();
            try (SeekableByteChannel channel = Files.newByteChannel(indexFile, WRITE_OPTIONS, new FileAttribute[0]);){
                do {
                    channel.write(buffer);
                } while (buffer.hasRemaining());
            }
        }
        finally {
            DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    @NotNull
    private static LoaderData buildData(@NotNull Path path, boolean isClassPathIndexEnabled) {
        long currentScanningTime;
        Path indexFile = isClassPathIndexEnabled ? path.resolve("classpath.index") : null;
        LoaderData loaderData = indexFile == null ? null : FileLoader.readFromIndex(indexFile);
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            StrippedLongArrayList nameHashes = new StrippedLongArrayList();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            FileLoader.buildPackageAndNameCache(path, loaderDataBuilder, nameHashes);
            loaderData = new LoaderData(loaderDataBuilder.resourcePackageHashes.toArray(), loaderDataBuilder.classPackageHashes.toArray(), new NameFilter(Xor16.construct(nameHashes.elements(), 0, nameHashes.size())));
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + path + " for " + doneNanos / (long)nsMsFactor + "ms");
            }
            if (isClassPathIndexEnabled) {
                try {
                    Path tempFile = indexFile.getParent().resolve("classpath.index.tmp");
                    FileLoader.saveIndex(loaderData, tempFile);
                    try {
                        Files.move(tempFile, indexFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        Files.move(tempFile, indexFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / (long)nsMsFactor + "ms, loading: " + totalReading.get() / (long)nsMsFactor + "ms for " + currentLoaders + " loaders");
        }
        return loaderData;
    }

    public String toString() {
        return "FileLoader(path=" + this.path + ')';
    }

    @Override
    public boolean containsName(String name) {
        return this.nameFilter.test(name);
    }

    private static final class NameFilter
    implements Predicate<String> {
        final Xor16 filter;

        NameFilter(Xor16 filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(String name) {
            if (name.isEmpty()) {
                return true;
            }
            int lastIndex = name.length() - 1;
            int end = name.charAt(lastIndex) == '/' ? lastIndex : name.length();
            return this.filter.mightContain(Xx3UnencodedString.hashUnencodedStringRange(name, 0, end));
        }
    }

    private static final class LoaderData
    implements ClasspathCache.IndexRegistrar {
        private final long[] resourcePackageHashes;
        private final long[] classPackageHashes;
        @NotNull
        private final NameFilter nameFilter;

        LoaderData(long[] resourcePackageHashes, long[] classPackageHashes, @NotNull NameFilter nameFilter) {
            this.resourcePackageHashes = resourcePackageHashes;
            this.classPackageHashes = classPackageHashes;
            this.nameFilter = nameFilter;
        }

        @Override
        public int classPackageCount() {
            return this.classPackageHashes.length;
        }

        @Override
        public int resourcePackageCount() {
            return this.resourcePackageHashes.length;
        }

        @Override
        @NotNull
        public Predicate<String> getNameFilter() {
            return this.nameFilter;
        }

        @Override
        public long[] classPackages() {
            return this.classPackageHashes;
        }

        @Override
        public long[] resourcePackages() {
            return this.resourcePackageHashes;
        }

        int approximateSizeInBytes() {
            return 8 + this.classPackageHashes.length * 8 + this.resourcePackageHashes.length * 8 + this.nameFilter.filter.sizeInBytes();
        }

        void save(@NotNull ByteBuffer buffer) {
            buffer.putInt(this.classPackageHashes.length);
            buffer.putInt(this.resourcePackageHashes.length);
            LongBuffer longBuffer = buffer.asLongBuffer();
            longBuffer.put(this.classPackageHashes);
            longBuffer.put(this.resourcePackageHashes);
            buffer.position(buffer.position() + longBuffer.position() * 8);
            this.nameFilter.filter.write(buffer);
        }
    }

    private static final class FileResource
    implements Resource {
        private URL url;
        private final Path file;

        FileResource(@NotNull Path file2) {
            this.file = file2;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                try {
                    result = this.file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
            }
            return result;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]), 32000);
        }

        @Override
        public byte @NotNull [] getBytes() throws IOException {
            return Files.readAllBytes(this.file);
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

