/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.containers.UnmodifiableHashMap;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DebugFMap
implements KeyFMap {
    static final boolean DEBUG_FMAP = Boolean.getBoolean("idea.keyfmap.debug.implementation");
    @NotNull
    private final UnmodifiableHashMap<Key<?>, Object> myMap;

    DebugFMap(@NotNull UnmodifiableHashMap<Key<?>, Object> map) {
        this.myMap = map;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        UnmodifiableHashMap<Key<?>, Object> newMap = this.myMap.with(key, value);
        return newMap == this.myMap ? this : new DebugFMap(newMap);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        UnmodifiableHashMap<Key<?>, Object> newMap = this.myMap.without(key);
        return newMap == this.myMap ? this : new DebugFMap(newMap);
    }

    @Override
    @Nullable
    public <V> V get(@NotNull Key<V> key) {
        Object value = this.myMap.get(key);
        return (V)value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyFMap)) {
            return false;
        }
        KeyFMap other = (KeyFMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return this.myMap.entrySet().stream().allMatch(entry -> Objects.equals(entry.getValue(), other.get((Key)entry.getKey())));
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @NotNull
    public @NotNull Key @NotNull [] getKeys() {
        return this.myMap.keySet().toArray(new Key[0]);
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public int getValueIdentityHashCode() {
        int[] hash = new int[]{0};
        this.myMap.forEach((key, value) -> {
            hash[0] = (hash[0] * 31 + key.hashCode()) * 31 + System.identityHashCode(value);
        });
        return hash[0];
    }

    @Override
    public boolean equalsByReference(@NotNull KeyFMap other) {
        if (this.size() != other.size()) {
            return false;
        }
        return this.myMap.entrySet().stream().allMatch(entry -> entry.getValue() == other.get((Key)entry.getKey()));
    }
}

