/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.zip.JBZipExtraField;
import com.intellij.util.io.zip.ZipShort;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class UnrecognizedExtraField
implements JBZipExtraField {
    @NotNull
    private final ZipShort myHeaderId;
    private byte[] myLocalData;
    private byte[] myCentralData;

    UnrecognizedExtraField(@NotNull ZipShort headerId) {
        this.myHeaderId = headerId;
    }

    @Override
    @NotNull
    public ZipShort getHeaderId() {
        return this.myHeaderId;
    }

    public void setLocalFileDataData(byte[] data) {
        this.myLocalData = ArrayUtil.copyOf(data);
    }

    @Override
    @NotNull
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.myLocalData != null ? this.myLocalData.length : 0);
    }

    @Override
    public byte @NotNull [] getLocalFileDataData() {
        return ArrayUtil.copyOf(this.myLocalData);
    }

    public void setCentralDirectoryData(byte[] data) {
        this.myCentralData = ArrayUtil.copyOf(data);
    }

    @Override
    @NotNull
    public ZipShort getCentralDirectoryLength() {
        if (this.myCentralData != null) {
            return new ZipShort(this.myCentralData.length);
        }
        return this.getLocalFileDataLength();
    }

    @Override
    public byte @NotNull [] getCentralDirectoryData() {
        if (this.myCentralData != null) {
            return ArrayUtil.copyOf(this.myCentralData);
        }
        return this.getLocalFileDataData();
    }

    @Override
    public void parseFromLocalFileData(byte @NotNull [] data, int offset, int length) {
        this.setLocalFileDataData(Arrays.copyOfRange(data, offset, offset + length));
    }

    @Override
    public void parseFromCentralDirectoryData(byte @NotNull [] data, int offset, int length) {
        byte[] tmp = Arrays.copyOfRange(data, offset, offset + length);
        this.setCentralDirectoryData(tmp);
        if (this.myLocalData == null) {
            this.setLocalFileDataData(tmp);
        }
    }
}

