/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RecordsTable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class Storage
extends AbstractStorage {
    public Storage(@NotNull Path path) throws IOException {
        super(path);
    }

    public Storage(@NotNull Path path, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        super(path, capacityAllocationPolicy);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(@NotNull StorageLockContext pool, @NotNull Path recordsFile) throws IOException {
        return new RecordsTable(recordsFile, pool);
    }

    public int createNewRecord() throws IOException {
        return (Integer)this.withWriteLock(() -> this.myRecordsTable.createNewRecord());
    }

    public void deleteRecord(int record) throws IOException {
        assert (record > 0);
        this.withWriteLock(() -> this.doDeleteRecord(record));
    }
}

