/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.UtilBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance(HeavyProcessLatch.class);
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final List<Operation> myHeavyProcesses = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final Queue<Runnable> myExecuteOutOfHeavyActivity = new ConcurrentLinkedQueue<Runnable>();

    private HeavyProcessLatch() {
    }

    @Deprecated
    @NotNull
    public AccessToken processStarted(@NotNull @Nls String displayName) {
        final Op op = new Op(Type.Processing, displayName);
        this.myHeavyProcesses.add(op);
        this.myEventDispatcher.getMulticaster().processStarted(op);
        return new AccessToken(){

            @Override
            public void finish() {
                ((HeavyProcessListener)HeavyProcessLatch.this.myEventDispatcher.getMulticaster()).processFinished(op);
                HeavyProcessLatch.this.myHeavyProcesses.remove(op);
                HeavyProcessLatch.this.executeHandlers();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(@NotNull Type type, @NotNull @Nls String displayName, @NotNull Runnable runnable) {
        Op op = new Op(type, displayName);
        this.myHeavyProcesses.add(op);
        this.myEventDispatcher.getMulticaster().processStarted(op);
        try {
            runnable.run();
        }
        finally {
            this.myEventDispatcher.getMulticaster().processFinished(op);
            this.myHeavyProcesses.remove(op);
            this.executeHandlers();
        }
    }

    private void executeHandlers() {
        if (!this.isRunning()) {
            Runnable runnable;
            while ((runnable = this.myExecuteOutOfHeavyActivity.poll()) != null) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
    }

    public boolean isRunning() {
        return !this.myHeavyProcesses.isEmpty();
    }

    public boolean isRunning(@NotNull Type type) {
        return ContainerUtil.exists(this.myHeavyProcesses, op -> op.getType() == type);
    }

    public boolean isRunningAnythingBut(@NotNull Type type) {
        return ContainerUtil.exists(this.myHeavyProcesses, op -> op.getType() != type);
    }

    public Operation getAnyRunningOperation() {
        Iterator<Operation> iterator = this.myHeavyProcesses.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @NotNull
    public Collection<Operation> getRunningOperations() {
        return new ArrayList<Operation>(this.myHeavyProcesses);
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public void queueExecuteOutOfHeavyProcess(@NotNull Runnable runnable) {
        if (this.isRunning()) {
            this.myExecuteOutOfHeavyActivity.add(runnable);
        } else {
            runnable.run();
        }
    }

    private static final class Op
    implements Operation {
        private final Type myType;
        @NotNull
        @Nls
        private final String myDisplayName;

        Op(@NotNull Type type, @NotNull @Nls String displayName) {
            this.myType = type;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public Type getType() {
            return this.myType;
        }

        @Override
        @Nls
        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }
    }

    public static interface Operation {
        @NotNull
        public Type getType();

        @NotNull
        @Nls
        public String getDisplayName();
    }

    public static interface HeavyProcessListener
    extends EventListener {
        default public void processStarted(@NotNull Operation op) {
        }

        public void processFinished(@NotNull Operation var1);
    }

    public static enum Type {
        Indexing("heavyProcess.type.indexing"),
        Syncing("heavyProcess.type.syncing"),
        Processing("heavyProcess.type.processing");

        private final String bundleKey;

        private Type(String bundleKey) {
            this.bundleKey = bundleKey;
        }

        @Nls
        public String toString() {
            return UtilBundle.message(this.bundleKey, new Object[0]);
        }
    }
}

