/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class InlinedKeyStorage<Data>
implements AppendableObjectStorage<Data> {
    private final InlineKeyDescriptor<Data> myDescriptor;

    public InlinedKeyStorage(@NotNull InlineKeyDescriptor<Data> descriptor) {
        this.myDescriptor = descriptor;
    }

    @Override
    public Data read(int addr) throws IOException {
        return this.myDescriptor.fromInt(addr);
    }

    @Override
    public boolean processAll(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int append(Data value) throws IOException {
        return this.myDescriptor.toInt(value);
    }

    @Override
    public boolean checkBytesAreTheSame(int addr, Data value) {
        return false;
    }

    @Override
    public void clear() throws IOException {
    }

    @Override
    public void lockRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlockRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lockWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlockWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCurrentLength() {
        return -1;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void force() {
    }

    @Override
    public void close() throws IOException {
    }
}

