/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataEnumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator
implements DataEnumerator<String> {
    @NotNull
    private final Path myFile;
    @NotNull
    private final Object2IntMap<String> myInvertedState;
    @NotNull
    private final Int2ObjectMap<String> myForwardState;

    public SimpleStringPersistentEnumerator(@NotNull Path file2) {
        this.myFile = file2;
        Pair<Object2IntMap<String>, Int2ObjectMap<String>> pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file2);
        this.myInvertedState = (Object2IntMap)pair.getFirst();
        this.myForwardState = (Int2ObjectMap)pair.getSecond();
    }

    @NotNull
    public Path getFile() {
        return this.myFile;
    }

    @Override
    public synchronized int enumerate(@Nullable String value) {
        int id = this.myInvertedState.getInt((Object)value);
        if (id != this.myInvertedState.defaultReturnValue()) {
            return id;
        }
        if (value != null && StringUtil.containsLineBreak(value)) {
            throw new RuntimeException("SimpleStringPersistentEnumerator doesn't support multi-line strings");
        }
        int n = this.myInvertedState.size() + 1;
        this.myInvertedState.put((Object)value, n);
        this.myForwardState.put(n, (Object)value);
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile);
        return n;
    }

    @NotNull
    public synchronized Collection<String> entries() {
        return new ArrayList<String>((Collection<String>)this.myInvertedState.keySet());
    }

    @NotNull
    public synchronized Map<String, Integer> getInvertedState() {
        return Collections.unmodifiableMap(this.myInvertedState);
    }

    @Override
    @Nullable
    public synchronized String valueOf(int idx) {
        return (String)this.myForwardState.get(idx);
    }

    public synchronized void forceDiskSync() {
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile);
    }

    public synchronized boolean isEmpty() {
        return this.myInvertedState.isEmpty();
    }

    @NotNull
    public String dumpToString() {
        return this.myInvertedState.object2IntEntrySet().stream().sorted(Comparator.comparing(e -> e.getIntValue())).map(e -> (String)e.getKey() + "->" + e.getIntValue()).collect(Collectors.joining("\n"));
    }

    @NotNull
    private static Pair<Object2IntMap<String>, Int2ObjectMap<String>> readStorageFromDisk(@NotNull Path file2) {
        try {
            Object2IntOpenHashMap nameToIdRegistry = new Object2IntOpenHashMap();
            Int2ObjectOpenHashMap idToNameRegistry = new Int2ObjectOpenHashMap();
            List<String> lines = Files.readAllLines(file2, Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                String name = lines.get(i);
                nameToIdRegistry.put((Object)name, i + 1);
                idToNameRegistry.put(i + 1, (Object)name);
            }
            return Pair.create((Object)nameToIdRegistry, (Object)idToNameRegistry);
        }
        catch (IOException e) {
            SimpleStringPersistentEnumerator.writeStorageToDisk((Int2ObjectMap<String>)Int2ObjectMaps.emptyMap(), file2);
            return Pair.create((Object)new Object2IntOpenHashMap(), (Object)new Int2ObjectOpenHashMap());
        }
    }

    private static void writeStorageToDisk(@NotNull Int2ObjectMap<String> forwardIndex, @NotNull Path file2) {
        try {
            String[] names = new String[forwardIndex.size()];
            ObjectIterator iterator = Int2ObjectMaps.fastIterator(forwardIndex);
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                names[entry.getIntKey() - 1] = (String)entry.getValue();
            }
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.write(file2, Arrays.asList(names), Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

