/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentStringEnumerator
extends PersistentEnumerator<String>
implements AbstractStringEnumerator {
    @Nullable
    private final CachingEnumerator<String> myCache;

    public PersistentStringEnumerator(@NotNull Path file2) throws IOException {
        this(file2, null);
    }

    public PersistentStringEnumerator(@NotNull Path file2, @Nullable StorageLockContext storageLockContext) throws IOException {
        this(file2, 4096, storageLockContext);
    }

    public PersistentStringEnumerator(@NotNull Path file2, boolean cacheLastMappings) throws IOException {
        this(file2, 4096, cacheLastMappings, null);
    }

    public PersistentStringEnumerator(@NotNull Path file2, int initialSize) throws IOException {
        this(file2, initialSize, null);
    }

    public PersistentStringEnumerator(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this(file2, initialSize, false, lockContext);
    }

    public PersistentStringEnumerator(@NotNull Path file2, int initialSize, boolean cacheLastMappings, @Nullable StorageLockContext lockContext) throws IOException {
        super(file2, EnumeratorStringDescriptor.INSTANCE, initialSize, lockContext);
        this.myCache = cacheLastMappings ? new CachingEnumerator<String>(new DataEnumerator<String>(){

            @Override
            public int enumerate(@Nullable String value) throws IOException {
                return PersistentStringEnumerator.super.enumerate(value);
            }

            @Override
            @Nullable
            public String valueOf(int idx) throws IOException {
                return (String)PersistentStringEnumerator.super.valueOf(idx);
            }
        }, EnumeratorStringDescriptor.INSTANCE) : null;
    }

    @Override
    public int enumerate(@Nullable String value) throws IOException {
        return this.myCache != null ? this.myCache.enumerate(value) : super.enumerate(value);
    }

    @Override
    @Nullable
    public String valueOf(int idx) throws IOException {
        return this.myCache != null ? this.myCache.valueOf(idx) : (String)super.valueOf(idx);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myCache != null) {
            this.myCache.close();
        }
    }
}

