/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class PersistentMapInMemory<Key, Value>
implements PersistentMapBase<Key, Value> {
    private final Object myLock = new Object();
    private final ConcurrentHashMap<Key, Value> myMap = new ConcurrentHashMap();
    private final AtomicBoolean myIsClosed = new AtomicBoolean(false);
    private final DataExternalizer<Value> myValueExternalizer;

    public PersistentMapInMemory(@NotNull PersistentMapBuilder<Key, Value> builder) {
        this.myValueExternalizer = builder.getValueExternalizer();
    }

    @Override
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public Object getDataAccessLock() {
        return this.myLock;
    }

    @Override
    public void closeAndDelete() {
        this.myMap.clear();
    }

    @Override
    public void put(Key key, Value value) throws IOException {
        this.myMap.put(key, value);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        return this.processExistingKeys(processor);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void markDirty() throws IOException {
    }

    @Override
    public boolean processExistingKeys(@NotNull Processor<? super Key> processor) throws IOException {
        for (Object key : this.myMap.keySet()) {
            if (processor.process(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value get(Key key) throws IOException {
        return this.myMap.get(key);
    }

    @Override
    public boolean containsKey(Key key) throws IOException {
        return this.myMap.containsKey(key);
    }

    @Override
    public void remove(Key key) throws IOException {
        this.myMap.remove(key);
    }

    @Override
    public void force() {
    }

    @Override
    public boolean isClosed() {
        return this.myIsClosed.get();
    }

    @Override
    public void close() throws IOException {
        this.myIsClosed.set(true);
    }
}

