/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PersistentMapBase<Key, Value> {
    @ApiStatus.OverrideOnly
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer();

    default public void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataExternalizer<Value> dataExternalizer = this.getValuesExternalizer();
        Value oldValue = this.get(key);
        if (oldValue != null) {
            dataExternalizer.save(dos, oldValue);
        }
        appender.append(dos);
        dos.close();
        DataInputStream dis = new DataInputStream(bos.toInputStream());
        Value newValue = dataExternalizer.read(dis);
        dis.close();
        this.put(key, newValue);
    }

    public boolean processExistingKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean processKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean containsKey(Key var1) throws IOException;

    public Value get(Key var1) throws IOException;

    public void put(Key var1, Value var2) throws IOException;

    public void remove(Key var1) throws IOException;

    public boolean isDirty();

    public void markDirty() throws IOException;

    public void force() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void closeAndDelete() throws IOException;
}

