/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOUtil {
    @ApiStatus.Internal
    public static final ThreadLocal<Boolean> OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP = new ThreadLocal<Boolean>(){

        @Override
        public void set(Boolean value) {
            if (this.get() != null) {
                throw new RuntimeException("Reentrant access");
            }
            super.set(value);
        }
    };
    @ApiStatus.Internal
    public static final String SHARED_CACHES_PROP = "idea.shared.caches";
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte @NotNull [] create() {
            return IOUtil.allocReadWriteUTFBuffer();
        }
    };

    @ApiStatus.Internal
    public static boolean useNativeByteOrderForByteBuffers() {
        Boolean forced = OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.get();
        return forced == null || forced != false;
    }

    public static boolean isSharedCachesEnabled() {
        return SystemProperties.getBooleanProperty(SHARED_CACHES_PROP, false);
    }

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, StandardCharsets.UTF_16BE);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static void writeString(@Nullable String s, @NotNull DataOutput stream) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull String value) throws IOException {
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage);
    }

    public static byte @NotNull [] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull String value) throws IOException {
        int len = value.length();
        if (len < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            IOUtil.writeString(value, storage);
        }
    }

    public static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage) throws IOException {
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    public static boolean isAscii(@NotNull String str) {
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull Path file2) {
        List files2;
        String baseName = file2.getFileName().toString();
        Path parentFile = file2.getParent();
        if (parentFile == null) {
            return true;
        }
        try (Stream<Path> stream = Files.list(parentFile);){
            files2 = stream.filter(it -> it.getFileName().toString().startsWith(baseName)).collect(Collectors.toList());
        }
        catch (NoSuchFileException ignore) {
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
        boolean ok = true;
        for (Path f : files2) {
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException ignore) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file2) {
        String baseName = file2.getName();
        File parentFile = file2.getParentFile();
        File[] files2 = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files2 != null) {
            for (File f : files2) {
                ok &= FileUtilRt.delete((File)f);
            }
        }
        return ok;
    }

    public static void syncStream(@NotNull OutputStream stream) throws IOException {
        stream.flush();
        try {
            Object o;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while (stream instanceof FilterOutputStream && (o = outField.get(stream)) instanceof OutputStream) {
                stream = (OutputStream)o;
            }
            if (stream instanceof FileOutputStream) {
                ((FileOutputStream)stream).getFD().sync();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Path file2) throws IOException {
        return IOUtil.openCleanOrResetBroken(factoryComputable, file2.toFile());
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file2) throws IOException {
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file2));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        try {
            return (T)factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return (T)factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list) throws IOException {
        DataInputOutputUtil.writeINT(out, list.size());
        for (String s : list) {
            IOUtil.writeUTF(out, s);
        }
    }

    @NotNull
    public static <C extends Collection<String>> C readStringCollection(@NotNull DataInput in, @NotNull IntFunction<? extends C> collectionGenerator) throws IOException {
        int size = DataInputOutputUtil.readINT(in);
        Collection strings2 = (Collection)collectionGenerator.apply(size);
        for (int i = 0; i < size; ++i) {
            strings2.add(IOUtil.readUTF(in));
        }
        return (C)strings2;
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        return IOUtil.readStringCollection(in, ArrayList::new);
    }

    public static void closeSafe(@NotNull Logger log, Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

