/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.system.CpuArch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FilePageCache {
    private static final Logger LOG = Logger.getInstance(FilePageCache.class);
    static final long MAX_PAGES_COUNT = 0xFFFFFFFFL;
    private static final long FILE_INDEX_MASK = -4294967296L;
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    static final int BUFFER_SIZE;
    private final Int2ObjectMap<PagedFileStorage> myIndex2Storage = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final LinkedHashMap<Long, DirectBufferWrapper> mySegments;
    private final ReentrantLock mySegmentsAccessLock = new ReentrantLock();
    private final ReentrantLock mySegmentsAllocationLock = new ReentrantLock();
    private final LinkedHashMap<Long, DirectBufferWrapper> mySegmentsToRemove = new LinkedHashMap();
    private final long mySizeLimit = UPPER_LIMIT;
    private long mySize;
    private volatile int myUncachedFileAccess;
    private int myFastCacheHits;
    private int myHits;
    private int myMisses;
    private int myLoad;
    private volatile int myMaxRegisteredFiles;
    private long myMaxLoadedSize;
    private volatile int myMappingChangeCount;
    private long myCreatedCount;
    private long myCreatedMs;
    private long myDisposalMs;

    void assertUnderSegmentAllocationLock() {
        assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
    }

    public void incrementUncachedFileAccess() {
        ++this.myUncachedFileAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoBuffersLocked() {
        this.mySegmentsAllocationLock.lock();
        try {
            this.mySegmentsAccessLock.lock();
            try {
                for (DirectBufferWrapper value : this.mySegments.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
                for (DirectBufferWrapper value : this.mySegmentsToRemove.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    public void incrementFastCacheHitsCount() {
        ++this.myFastCacheHits;
    }

    public long getMaxSize() {
        return this.mySizeLimit;
    }

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("jdk.internal.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("sun.misc.VM");
                Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
                return (Long)maxDirectMemory.invoke(null, new Object[0]);
            }
            catch (Throwable aClass2) {
                try {
                    Class<?> aClass3 = Class.forName("java.nio.Bits");
                    Field maxMemory = aClass3.getDeclaredField("maxMemory");
                    maxMemory.setAccessible(true);
                    return (Long)maxMemory.get(null);
                }
                catch (Throwable aClass3) {
                    try {
                        Class<?> aClass4 = Class.forName("java.nio.Bits");
                        Field maxMemory = aClass4.getDeclaredField("MAX_MEMORY");
                        maxMemory.setAccessible(true);
                        return (Long)maxMemory.get(null);
                    }
                    catch (Throwable throwable) {
                        return Runtime.getRuntime().maxMemory();
                    }
                }
            }
        }
    }

    @NotNull
    FilePageCacheStatistics getStatistics() {
        this.mySegmentsAllocationLock.lock();
        try {
            this.mySegmentsAccessLock.lock();
            try {
                FilePageCacheStatistics filePageCacheStatistics = new FilePageCacheStatistics(PagedFileStorage.CHANNELS_CACHE.getStatistics(), this.myUncachedFileAccess, this.myMaxRegisteredFiles, this.myMaxLoadedSize, this.myHits, this.myFastCacheHits, this.myMisses, this.myLoad, this.myMappingChangeCount, this.mySizeLimit);
                this.mySegmentsAccessLock.unlock();
                return filePageCacheStatistics;
            }
            catch (Throwable throwable) {
                this.mySegmentsAccessLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    FilePageCache() {
        this.mySegments = new LinkedHashMap<Long, DirectBufferWrapper>(10, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry<Long, DirectBufferWrapper> eldest) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                return FilePageCache.this.mySize > FilePageCache.this.mySizeLimit;
            }

            public DirectBufferWrapper put(Long key, @NotNull DirectBufferWrapper wrapper) {
                FilePageCache.this.mySize += wrapper.getLength();
                DirectBufferWrapper oldShouldBeNull = (DirectBufferWrapper)super.put((Object)key, (Object)wrapper);
                FilePageCache.this.myMaxLoadedSize = Math.max(FilePageCache.this.myMaxLoadedSize, FilePageCache.this.mySize);
                return oldShouldBeNull;
            }

            @Nullable
            public DirectBufferWrapper remove(Object key) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                DirectBufferWrapper wrapper = (DirectBufferWrapper)super.remove(key);
                if (wrapper != null) {
                    ++FilePageCache.this.myMappingChangeCount;
                    FilePageCache.this.mySegmentsToRemove.put((Object)((Long)key), (Object)wrapper);
                    FilePageCache.this.mySize -= wrapper.getLength();
                }
                return wrapper;
            }
        };
    }

    int getMappingChangeCount() {
        return this.myMappingChangeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.myIndex2Storage;
        synchronized (int2ObjectMap) {
            int registered = this.myIndex2Storage.size();
            int value = registered << 16;
            while (this.myIndex2Storage.get(value) != null) {
                value = ++registered << 16;
            }
            this.myIndex2Storage.put(value, (Object)storage);
            this.myMaxRegisteredFiles = Math.max(this.myMaxRegisteredFiles, this.myIndex2Storage.size());
            return (long)value << 32;
        }
    }

    @NotNull(value="Seems accessed storage has been closed")
    private @NotNull(value="Seems accessed storage has been closed") PagedFileStorage getRegisteredPagedFileStorageByIndex(long key) {
        int storageIndex = (int)((key & 0xFFFFFFFF00000000L) >> 32);
        return (PagedFileStorage)this.myIndex2Storage.get(storageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectBufferWrapper get(Long key, boolean read) throws IOException {
        DirectBufferWrapper wrapper;
        try {
            this.mySegmentsAccessLock.lock();
            wrapper = (DirectBufferWrapper)this.mySegments.get((Object)key);
            if (wrapper != null) {
                ++this.myHits;
                DirectBufferWrapper directBufferWrapper = wrapper;
                return directBufferWrapper;
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            DirectBufferWrapper notYetRemoved = (DirectBufferWrapper)this.mySegmentsToRemove.remove((Object)key);
            if (notYetRemoved != null) {
                DirectBufferWrapper previous;
                this.mySegmentsAccessLock.lock();
                try {
                    previous = (DirectBufferWrapper)this.mySegments.put((Object)key, (Object)notYetRemoved);
                    assert (previous == null);
                }
                finally {
                    this.mySegmentsAccessLock.unlock();
                }
                this.disposeRemovedSegments(null);
                ++this.myHits;
                previous = notYetRemoved;
                return previous;
            }
            this.mySegmentsAccessLock.lock();
            try {
                wrapper = (DirectBufferWrapper)this.mySegments.get((Object)key);
                if (wrapper != null) {
                    DirectBufferWrapper previous = wrapper;
                    return previous;
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            PagedFileStorage fileStorage = this.getRegisteredPagedFileStorageByIndex(key);
            this.disposeRemovedSegments(null);
            long disposed = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            wrapper = FilePageCache.createValue(key, read, fileStorage);
            if (IOStatistics.DEBUG) {
                long finished = System.currentTimeMillis();
                ++this.myCreatedCount;
                this.myCreatedMs += finished - disposed;
                this.myDisposalMs += disposed - started;
            }
            this.mySegmentsAccessLock.lock();
            try {
                if (this.mySize + (long)fileStorage.myPageSize < this.mySizeLimit) {
                    ++this.myLoad;
                } else {
                    ++this.myMisses;
                }
                this.mySegments.put((Object)key, (Object)wrapper);
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.ensureSize(this.mySizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper;
            return directBufferWrapper;
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    private void disposeRemovedSegments(@Nullable PagedFileStorage verificationStorage) {
        this.assertUnderSegmentAllocationLock();
        if (this.mySegmentsToRemove.isEmpty()) {
            return;
        }
        Iterator iterator = this.mySegmentsToRemove.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)iterator.next();
                DirectBufferWrapper wrapper = (DirectBufferWrapper)entry.getValue();
                boolean released = wrapper.tryRelease(wrapper.getFile() == verificationStorage);
                if (!released) continue;
                iterator.remove();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void ensureSize(long sizeLimit) {
        this.mySegmentsAllocationLock.isHeldByCurrentThread();
        try {
            this.mySegmentsAccessLock.lock();
            while (this.mySize > sizeLimit) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.disposeRemovedSegments(null);
    }

    @NotNull
    private static DirectBufferWrapper createValue(Long key, boolean read, PagedFileStorage owner) throws IOException {
        StorageLockContext context = owner.getStorageLockContext();
        if (read) {
            context.checkReadAccess();
        } else {
            context.checkWriteAccess();
        }
        long off = (key & 0xFFFFFFFFL) * (long)owner.myPageSize;
        return new DirectBufferWrapper(owner, off);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Long, DirectBufferWrapper> getBuffersForOwner(@NotNull PagedFileStorage storage) {
        StorageLockContext storageLockContext = storage.getStorageLockContext();
        this.mySegmentsAccessLock.lock();
        try {
            storageLockContext.checkReadAccess();
            TreeMap<Long, DirectBufferWrapper> mineBuffers = new TreeMap<Long, DirectBufferWrapper>();
            for (Map.Entry entry : this.mySegments.entrySet()) {
                if (((DirectBufferWrapper)entry.getValue()).getFile() != storage) continue;
                mineBuffers.put((Long)entry.getKey(), (DirectBufferWrapper)entry.getValue());
            }
            TreeMap<Long, DirectBufferWrapper> treeMap = mineBuffers;
            return treeMap;
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(PagedFileStorage fileStorage) {
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(fileStorage);
        if (!buffers.isEmpty()) {
            this.mySegmentsAccessLock.lock();
            try {
                for (Long key : buffers.keySet()) {
                    this.mySegments.remove((Object)key);
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments(fileStorage);
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    void flushBuffers() {
        this.mySegmentsAccessLock.lock();
        try {
            while (!this.mySegments.isEmpty()) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments(null);
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(PagedFileStorage storage) throws IOException {
        storage.getStorageLockContext().checkReadAccess();
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(storage);
        if (!buffers.isEmpty()) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.mySegmentsAllocationLock.lock();
            try {
                try {
                    for (DirectBufferWrapper buffer : buffers.values()) {
                        if (!buffer.isDirty() || buffer.isReleased()) continue;
                        buffer.force();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    void removeStorage(long index) {
        this.myIndex2Storage.remove((int)(index >> 32));
    }

    static {
        int lower = 100;
        int upper = CpuArch.is32Bit() ? 200 : 500;
        BUFFER_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        long max = FilePageCache.maxDirectMemory() - 2L * (long)BUFFER_SIZE;
        LOWER_LIMIT = (int)Math.min(0x6400000L, max);
        UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemProperties.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; max=" + max / 0x100000L);
    }
}

