/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.ResourceHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private final SLRUMap<K, Handle<T>> myCache;
    private final List<T> myElementsToBeDisposed = new ArrayList<T>();
    private final Object myCacheLock = new Object();
    private final Object myUpdateLock = new Object();

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUMap<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            protected void onDropFromCache(K key, @NotNull Handle<T> value) {
                value.release();
            }
        };
    }

    @NotNull
    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(@NotNull T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Handle<T> get(K key) {
        Handle<T> cached = this.getIfCached(key);
        if (cached != null) {
            return cached;
        }
        Object object = this.myUpdateLock;
        synchronized (object) {
            cached = this.getIfCached(key);
            if (cached != null) {
                return cached;
            }
            return this.createHandle(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handle<T> createHandle(K key) {
        try {
            Handle<T> cached = new Handle<T>(this.createAccessor(key), this);
            cached.allocate();
            Object object = this.myCacheLock;
            synchronized (object) {
                this.myCache.put(key, cached);
            }
            this.disposeInvalidAccessors();
            return cached;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeInvalidAccessors() {
        ArrayList<T> fileAccessorsToBeDisposed;
        Iterator iterator = this.myCacheLock;
        synchronized (iterator) {
            if (this.myElementsToBeDisposed.isEmpty()) {
                return;
            }
            fileAccessorsToBeDisposed = new ArrayList<T>(this.myElementsToBeDisposed);
            this.myElementsToBeDisposed.clear();
        }
        for (Object t : fileAccessorsToBeDisposed) {
            try {
                this.disposeAccessor(t);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<T> getIfCached(K key) {
        Object object = this.myCacheLock;
        synchronized (object) {
            Handle value = (Handle)this.myCache.get(key);
            if (value != null) {
                value.allocate();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        try {
            Object object = this.myCacheLock;
            synchronized (object) {
                boolean bl = this.myCache.remove(key);
                return bl;
            }
        }
        finally {
            Object object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        try {
            object = this.myCacheLock;
            synchronized (object) {
                this.myCache.clear();
            }
        }
        finally {
            object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    public int getHashCode(K value) {
        return value.hashCode();
    }

    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    public static final class Handle<T>
    extends ResourceHandle<T> {
        private final FileAccessorCache<?, ? super T> myOwner;
        @NotNull
        private final T myResource;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        public Handle(@NotNull T fileAccessor, @NotNull FileAccessorCache<?, ? super T> owner) {
            this.myResource = fileAccessor;
            this.myOwner = owner;
        }

        public void allocate() {
            this.myRefCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                Object object = ((FileAccessorCache)this.myOwner).myCacheLock;
                synchronized (object) {
                    ((FileAccessorCache)this.myOwner).myElementsToBeDisposed.add(this.myResource);
                }
            }
        }

        public int getRefCount() {
            return this.myRefCount.get();
        }

        @Override
        public void close() {
            this.release();
        }

        @Override
        @NotNull
        public T get() {
            return this.myResource;
        }
    }
}

