/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataInputOutputUtil {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    public static int readINT(@NotNull DataInput record) throws IOException {
        return DataInputOutputUtilRt.readINT((DataInput)record);
    }

    public static int readINT(@NotNull ByteBuffer byteBuffer) {
        return DataInputOutputUtilRt.readINT((ByteBuffer)byteBuffer);
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        DataInputOutputUtilRt.writeINT((DataOutput)record, (int)val);
    }

    public static void writeINT(@NotNull ByteBuffer byteBuffer, int val) {
        DataInputOutputUtilRt.writeINT((ByteBuffer)byteBuffer, (int)val);
    }

    public static long readLONG(@NotNull DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeLONG(@NotNull DataOutput record, long val) throws IOException {
        if (0L > val || val >= 192L) {
            record.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte((int)val);
    }

    public static int readSINT(@NotNull DataInput record) throws IOException {
        return DataInputOutputUtil.readINT(record) - 64;
    }

    public static void writeSINT(@NotNull DataOutput record, int val) throws IOException {
        DataInputOutputUtil.writeINT(record, val + 64);
    }

    public static void writeTIME(@NotNull DataOutput record, long timestamp) throws IOException {
        long relStamp = timestamp - 1040688000000L;
        if (relStamp < 0L || relStamp >= 0xFF00000000L) {
            record.writeByte(255);
            record.writeLong(timestamp);
        } else {
            record.writeByte((int)(relStamp >> 32));
            record.writeByte((int)(relStamp >> 24));
            record.writeByte((int)(relStamp >> 16));
            record.writeByte((int)(relStamp >> 8));
            record.writeByte((int)relStamp);
        }
    }

    public static long readTIME(@NotNull DataInput record) throws IOException {
        int first = record.readUnsignedByte();
        if (first == 255) {
            return record.readLong();
        }
        int second = record.readUnsignedByte();
        int third = record.readUnsignedByte() << 16;
        int fourth = record.readUnsignedByte() << 8;
        int fifth = record.readUnsignedByte();
        return ((long)(first << 8 | second) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static <T> void writeNullable(@NotNull DataOutput out, @Nullable T value, @NotNull ThrowableConsumer<? super T, ? extends IOException> writeValue) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            writeValue.consume(value);
        }
    }

    @Nullable
    public static <T> T readNullable(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, ? extends IOException> readValue) throws IOException {
        return (T)(in.readBoolean() ? readValue.compute() : null);
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, IOException> readElement) throws IOException {
        return DataInputOutputUtilRt.readSeq((DataInput)in, readElement);
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<? extends T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        DataInputOutputUtilRt.writeSeq((DataOutput)out, collection, writeElement);
    }
}

