/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

public final class CountingGZIPInputStream
extends GZIPInputStream {
    private final CountingInputStream myInputStream;

    private CountingGZIPInputStream(@NotNull CountingInputStream inputStream) throws IOException {
        super(inputStream);
        this.myInputStream = inputStream;
    }

    public long getCompressedBytesRead() {
        return this.myInputStream.getBytesRead();
    }

    @NotNull
    public static CountingGZIPInputStream create(@NotNull InputStream inputStream) throws IOException {
        return new CountingGZIPInputStream(new CountingInputStream(inputStream));
    }
}

