/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PosixFilePermissionsUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.function.BiPredicate;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Compressor
implements Closeable {
    @Nullable
    private @Nullable BiPredicate<? super String, ? super @Nullable Path> myFilter;

    public Compressor filter(@Nullable @Nullable BiPredicate<? super String, ? super @Nullable Path> filter) {
        this.myFilter = filter;
        return this;
    }

    public final void addFile(@NotNull String entryName, @NotNull File file2) throws IOException {
        this.addFile(entryName, file2.toPath());
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file2) throws IOException {
        this.addFile(entryName, file2, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file2, long timestamp) throws IOException {
        if (this.accept(entryName = Compressor.entryName(entryName), file2)) {
            this.addFile(file2, Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]), entryName, timestamp);
        }
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content) throws IOException {
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content, long timestamp) throws IOException {
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, new ByteArrayInputStream(content), content.length, Compressor.timestamp(timestamp), 0, null);
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content) throws IOException {
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content, long timestamp) throws IOException {
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, content, -1L, Compressor.timestamp(timestamp), 0, null);
        }
    }

    public final void addDirectory(@NotNull String entryName) throws IOException {
        this.addDirectory(entryName, -1L);
    }

    public final void addDirectory(@NotNull String entryName, long timestamp) throws IOException {
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeDirectoryEntry(entryName, Compressor.timestamp(timestamp));
        }
    }

    public final void addDirectory(@NotNull File directory) throws IOException {
        this.addDirectory(directory.toPath());
    }

    public final void addDirectory(@NotNull Path directory) throws IOException {
        this.addDirectory("", directory);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull File directory) throws IOException {
        this.addDirectory(prefix, directory.toPath());
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory) throws IOException {
        this.addDirectory(prefix, directory, -1L);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory, long timestampInMillis) throws IOException {
        String entryName = prefix.isEmpty() ? "" : Compressor.entryName(prefix);
        this.addRecursively(entryName, directory, timestampInMillis);
    }

    protected Compressor() {
    }

    private static String entryName(String name) {
        String entryName = StringUtil.trimLeading(StringUtil.trimTrailing(name.replace('\\', '/'), '/'), '/');
        if (entryName.isEmpty()) {
            throw new IllegalArgumentException("Invalid entry name: " + name);
        }
        return entryName;
    }

    private static long timestamp(long timestamp) {
        return timestamp == -1L ? System.currentTimeMillis() : timestamp;
    }

    private boolean accept(String entryName, @Nullable Path file2) {
        return this.myFilter == null || this.myFilter.test(entryName, file2);
    }

    private void addFile(Path file2, BasicFileAttributes attrs, String name, long explicitTimestamp) throws IOException {
        try (InputStream source = Files.newInputStream(file2, new OpenOption[0]);){
            long timestamp = explicitTimestamp == -1L ? attrs.lastModifiedTime().toMillis() : explicitTimestamp;
            String symlinkTarget = attrs.isSymbolicLink() ? Files.readSymbolicLink(file2).toString() : null;
            this.writeFileEntry(name, source, attrs.size(), timestamp, Compressor.mode(file2), symlinkTarget);
        }
    }

    private static int mode(Path file2) throws IOException {
        if (SystemInfo.isWindows) {
            DosFileAttributeView attrs = Files.getFileAttributeView(file2, DosFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                DosFileAttributes dosAttrs = attrs.readAttributes();
                int mode = 0;
                if (dosAttrs.isReadOnly()) {
                    mode |= 1;
                }
                if (dosAttrs.isHidden()) {
                    mode |= 2;
                }
                return mode;
            }
        } else {
            PosixFileAttributeView attrs = Files.getFileAttributeView(file2, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                return PosixFilePermissionsUtil.toUnixMode(attrs.readAttributes().permissions());
            }
        }
        return 0;
    }

    private void addRecursively(final String prefix, final Path root, final long timestampMs) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String name;
                String string2 = name = dir == root ? prefix : this.entryName(dir);
                if (name.isEmpty()) {
                    return FileVisitResult.CONTINUE;
                }
                if (Compressor.this.accept(name, dir)) {
                    Compressor.this.writeDirectoryEntry(name, timestampMs == -1L ? attrs.lastModifiedTime().toMillis() : timestampMs);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                String name = this.entryName(file2);
                if (Compressor.this.accept(name, file2)) {
                    Compressor.this.addFile(file2, attrs, name, timestampMs);
                }
                return FileVisitResult.CONTINUE;
            }

            private String entryName(Path fileOrDir) {
                String relativeName = Compressor.entryName(root.relativize(fileOrDir).toString());
                return prefix.isEmpty() ? relativeName : prefix + '/' + relativeName;
            }
        });
    }

    protected abstract void writeDirectoryEntry(String var1, long var2) throws IOException;

    protected abstract void writeFileEntry(String var1, InputStream var2, long var3, long var5, int var7, @Nullable String var8) throws IOException;

    public static class Jar
    extends Zip {
        public Jar(@NotNull File file2) throws IOException {
            super(new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(file2.toPath(), new OpenOption[0]))));
        }

        public final void addManifest(@NotNull Manifest manifest) throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            manifest.write(buffer);
            this.addFile("META-INF/MANIFEST.MF", buffer.toByteArray());
        }
    }

    public static class Zip
    extends Compressor {
        private final ZipOutputStream myStream;

        public Zip(@NotNull File file2) throws IOException {
            this(file2.toPath());
        }

        public Zip(@NotNull Path file2) throws IOException {
            this(new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(file2, new OpenOption[0]))));
        }

        public Zip(@NotNull OutputStream stream) {
            this(new ZipOutputStream(stream));
        }

        public Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        protected Zip(ZipOutputStream stream) {
            this.myStream = stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name + '/');
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp, int mode, @Nullable String symlinkTarget) throws IOException {
            ZipEntry e = new ZipEntry(name);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            if (length != 0L) {
                StreamUtil.copy(source, this.myStream);
            }
            this.myStream.closeEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }
    }

    public static class Tar
    extends Compressor {
        private final TarArchiveOutputStream myStream;

        public Tar(@NotNull File file2, @NotNull Compression compression) throws IOException {
            this(Files.newOutputStream(file2.toPath(), new OpenOption[0]), compression);
        }

        public Tar(@NotNull OutputStream stream, @NotNull Compression compression) throws IOException {
            this.myStream = new TarArchiveOutputStream(Tar.compressedStream(stream, compression));
            this.myStream.setLongFileMode(3);
        }

        private static OutputStream compressedStream(OutputStream stream, Compression compression) throws IOException {
            if (compression == Compression.GZIP) {
                return new GzipCompressorOutputStream(stream);
            }
            if (compression == Compression.BZIP2) {
                return new BZip2CompressorOutputStream(stream);
            }
            return stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name + '/');
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            this.myStream.closeArchiveEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp, int mode, @Nullable String symlinkTarget) throws IOException {
            TarArchiveEntry e;
            if (symlinkTarget == null) {
                e = new TarArchiveEntry(name);
            } else {
                e = new TarArchiveEntry(name, 50);
                e.setLinkName(symlinkTarget);
                length = 0L;
            }
            if (length < 0L) {
                if (source instanceof ByteArrayInputStream || source instanceof UnsyncByteArrayInputStream) {
                    length = source.available();
                } else {
                    BufferExposingByteArrayOutputStream temp = new BufferExposingByteArrayOutputStream();
                    StreamUtil.copy(source, temp);
                    length = temp.size();
                    source = new ByteArrayInputStream(temp.getInternalBuffer(), 0, temp.size());
                }
            }
            e.setSize(length);
            e.setModTime(timestamp);
            if (mode != 0) {
                e.setMode(mode);
            }
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            if (length > 0L) {
                StreamUtil.copy(source, (OutputStream)this.myStream);
            }
            this.myStream.closeArchiveEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        public static enum Compression {
            GZIP,
            BZIP2,
            NONE;

        }
    }
}

