/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;
    private final Options myOptions;
    private final char[] myInputBuffer = new char[8192];
    private final StringBuilder myLineBuffer = new StringBuilder();
    private boolean myCarry;

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        this(BaseOutputReader.createInputStreamReader(inputStream, charset));
    }

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @NotNull Options options) {
        this(BaseOutputReader.createInputStreamReader(inputStream, charset), options);
    }

    public BaseOutputReader(@NotNull Reader reader) {
        this(reader, new Options());
    }

    public BaseOutputReader(@NotNull Reader reader, @NotNull Options options) {
        super(options.policy());
        if (options.policy() == BaseDataReader.SleepingPolicy.BLOCKING && !(reader instanceof BaseInputStreamReader)) {
            throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
        }
        this.myReader = reader;
        this.myOptions = options;
    }

    private static Reader createInputStreamReader(@NotNull InputStream stream, @Nullable Charset charset) {
        return charset == null ? new BaseInputStreamReader(stream) : new BaseInputStreamReader(stream, charset);
    }

    @Override
    protected final boolean readAvailableNonBlocking() throws IOException {
        boolean read = false;
        try {
            int n;
            while (this.myReader.ready() && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0 && this.myOptions.sendIncompleteLines()) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        boolean read = false;
        try {
            int n;
            while ((n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read;
    }

    @Override
    protected void flush() {
        if (this.myLineBuffer.length() > 0) {
            this.sendText(this.myLineBuffer);
        }
    }

    private void processInput(char[] buffer, StringBuilder line, int n) {
        if (this.myOptions.splitToLines()) {
            for (int i = 0; i < n; ++i) {
                char c;
                if (i == 0 && this.myCarry) {
                    c = '\r';
                    --i;
                    this.myCarry = false;
                } else {
                    c = buffer[i];
                }
                if (c == '\r') {
                    if (i + 1 == n) {
                        this.myCarry = true;
                        continue;
                    }
                    if (buffer[i + 1] == '\n') continue;
                }
                if (c != '\n' || this.myOptions.sendIncompleteLines() || this.myOptions.withSeparators()) {
                    line.append(c);
                }
                if (c != 10) continue;
                this.sendText(line);
            }
            if (line.length() > 0 && this.myOptions.sendIncompleteLines()) {
                this.sendText(line);
            }
        } else {
            this.onTextAvailable(new String(buffer, 0, n));
        }
    }

    private void sendText(@NotNull StringBuilder line) {
        String text = line.toString();
        line.setLength(0);
        this.onTextAvailable(text);
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);

    public static class Options {
        public static final Options BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.BLOCKING);
        public static final Options NON_BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.NON_BLOCKING);

        public BaseDataReader.SleepingPolicy policy() {
            return null;
        }

        public boolean splitToLines() {
            return true;
        }

        public boolean sendIncompleteLines() {
            return true;
        }

        public boolean withSeparators() {
            return true;
        }

        public static Options withPolicy(final BaseDataReader.SleepingPolicy policy) {
            return new Options(){

                @Override
                public BaseDataReader.SleepingPolicy policy() {
                    return policy;
                }
            };
        }

        public static Options forMostlySilentProcess() {
            if (SystemProperties.getBooleanProperty("output.reader.blocking.mode.for.mostly.silent.processes", true) || Boolean.getBoolean("output.reader.blocking.mode")) {
                return BLOCKING;
            }
            return NON_BLOCKING;
        }
    }
}

