/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMapBasedForwardIndex
implements ForwardIndex {
    @NotNull
    private volatile PersistentMap<Integer, ByteArraySequence> myPersistentMap;
    @NotNull
    private final Path myMapFile;
    private final boolean myUseChunks;
    private final boolean myReadOnly;
    @Nullable
    private final StorageLockContext myStorageLockContext;

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean isReadOnly) throws IOException {
        this(mapFile, true, isReadOnly, null);
    }

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean useChunks, boolean isReadOnly, @Nullable StorageLockContext storageLockContext) throws IOException {
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(mapFile, useChunks, isReadOnly, storageLockContext);
        this.myStorageLockContext = storageLockContext;
        this.myMapFile = mapFile;
        this.myUseChunks = useChunks;
        this.myReadOnly = isReadOnly;
    }

    @Override
    @Nullable
    public ByteArraySequence get(@NotNull Integer key) throws IOException {
        return (ByteArraySequence)this.myPersistentMap.get(key);
    }

    @Override
    public void put(@NotNull Integer key, @Nullable ByteArraySequence value) throws IOException {
        if (value == null) {
            this.myPersistentMap.remove(key);
        } else {
            this.myPersistentMap.put(key, value);
        }
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public void clear() throws IOException {
        this.myPersistentMap.closeAndClean();
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(this.myMapFile, this.myUseChunks, this.myReadOnly, this.myStorageLockContext);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    public boolean containsMapping(int key) throws IOException {
        return this.myPersistentMap.containsMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PersistentMap<Integer, ByteArraySequence> createMap(@NotNull Path file2, boolean useChunks, boolean isReadOnly, @Nullable StorageLockContext storageLockContext) throws IOException {
        assert (PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() == null || storageLockContext == null);
        PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(storageLockContext);
        try {
            PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = PersistentMapBuilder.newBuilder(file2, EnumeratorIntegerDescriptor.INSTANCE, ByteSequenceDataExternalizer.INSTANCE).hasChunks(useChunks).withReadonly(isReadOnly).build();
            return persistentHashMap;
        }
        finally {
            PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
        }
    }
}

