/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyCollectionForwardIndexAccessor<Key, Value>
extends AbstractForwardIndexAccessor<Key, Value, Collection<Key>> {
    public KeyCollectionForwardIndexAccessor(@NotNull DataExternalizer<Collection<Key>> externalizer) {
        super(externalizer);
    }

    public KeyCollectionForwardIndexAccessor(@NotNull IndexExtension<Key, Value, ?> extension) {
        this((DataExternalizer<Collection<Key>>)new InputIndexDataExternalizer<Key>(extension.getKeyDescriptor(), extension.getName()));
    }

    @Override
    protected InputDataDiffBuilder<Key, Value> createDiffBuilder(int inputId, @Nullable Collection<Key> keys) {
        return new KeyCollectionInputDataDiffBuilder(inputId, keys != null ? keys : Collections.emptySet());
    }

    @Override
    @Nullable
    public Collection<Key> convertToDataType(@NotNull InputData<Key, Value> data) {
        Set<Key> keys = data.getKeyValues().keySet();
        return keys.isEmpty() ? null : keys;
    }

    @Override
    protected int getBufferInitialSize(@NotNull Collection<Key> keys) {
        return 4 * keys.size();
    }

    private static final class KeyCollectionInputDataDiffBuilder<Key, Value>
    extends DirectInputDataDiffBuilder<Key, Value> {
        @NotNull
        private final Collection<Key> myKeys;

        KeyCollectionInputDataDiffBuilder(int inputId, @NotNull Collection<Key> keys) {
            super(inputId);
            this.myKeys = keys;
        }

        @Override
        public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
            for (Key key : this.myKeys) {
                removeProcessor.process(key, this.myInputId);
            }
            boolean anyAdded = EmptyInputDataDiffBuilder.processAllKeyValuesAsAdded(this.myInputId, newData, addProcessor);
            boolean anyRemoved = !this.myKeys.isEmpty();
            return anyAdded || anyRemoved;
        }

        @Override
        @NotNull
        public Collection<Key> getKeys() {
            return this.myKeys;
        }
    }
}

