/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForwardIndexAccessor<Key, Value, DataType>
implements ForwardIndexAccessor<Key, Value> {
    @NotNull
    private final DataExternalizer<DataType> myDataTypeExternalizer;
    private static final ThreadLocalCachedByteArray ourSpareByteArrayForKeys = new ThreadLocalCachedByteArray();
    private static final ThreadLocalCachedByteArray ourSpareByteArrayForValues = new ThreadLocalCachedByteArray();

    public AbstractForwardIndexAccessor(@NotNull DataExternalizer<DataType> externalizer) {
        this.myDataTypeExternalizer = externalizer;
    }

    protected abstract InputDataDiffBuilder<Key, Value> createDiffBuilder(int var1, @Nullable DataType var2) throws IOException;

    @Nullable
    public DataType deserializeData(@Nullable ByteArraySequence sequence) throws IOException {
        if (sequence == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.deserializeFromByteSeq(sequence, this.myDataTypeExternalizer);
    }

    @Override
    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        return this.createDiffBuilder(inputId, this.deserializeData(sequence));
    }

    @Nullable
    public abstract DataType convertToDataType(@NotNull InputData<Key, Value> var1);

    @Override
    @Nullable
    public ByteArraySequence serializeIndexedData(@NotNull InputData<Key, Value> data) throws IOException {
        return this.serializeIndexedData(this.convertToDataType(data));
    }

    @Nullable
    public ByteArraySequence serializeIndexedData(@Nullable DataType data) throws IOException {
        if (data == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.serializeValueToByteSeq(data, this.myDataTypeExternalizer, this.getBufferInitialSize(data));
    }

    protected int getBufferInitialSize(@NotNull DataType dataType) {
        return 4;
    }

    public static <Data> ByteArraySequence serializeKeyToByteSeq(Data data, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize) throws IOException {
        return AbstractForwardIndexAccessor.serializeToByteSeq(data, externalizer, bufferInitialSize, ourSpareByteArrayForKeys);
    }

    public static <Data> ByteArraySequence serializeValueToByteSeq(Data data, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize) throws IOException {
        return AbstractForwardIndexAccessor.serializeToByteSeq(data, externalizer, bufferInitialSize, ourSpareByteArrayForValues);
    }

    @Nullable
    public static <Data> ByteArraySequence serializeToByteSeq(Data data, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize, @NotNull ThreadLocalCachedByteArray cachedBufferToUse) throws IOException {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(s -> cachedBufferToUse.getBuffer(s), bufferInitialSize);
        DataOutputStream stream = new DataOutputStream(out);
        externalizer.save(stream, data);
        return out.size() == 0 ? null : out.toByteArraySequence();
    }

    public static <Data> Data deserializeFromByteSeq(@NotNull ByteArraySequence bytes, @NotNull DataExternalizer<Data> externalizer) throws IOException {
        return externalizer.read(bytes.toInputStream());
    }
}

