/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValueSerializationChecker<Value, Input> {
    private static final Logger LOG = Logger.getInstance(ValueSerializationChecker.class);
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    @NotNull
    private final IndexId<?, Value> myIndexId;
    @NotNull
    private final ValueSerializationProblemReporter myProblemReporter;
    static final ValueSerializationProblemReporter DEFAULT_SERIALIZATION_PROBLEM_REPORTER = ex -> LOG.error(ex);

    ValueSerializationChecker(@NotNull IndexExtension<?, Value, ?> extension, @NotNull ValueSerializationProblemReporter reporter) {
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myIndexId = extension.getName();
        this.myProblemReporter = reporter;
    }

    void checkValueSerialization(@NotNull Map<?, Value> data, @NotNull Input input) {
        Exception problem;
        if (IndexDebugProperties.DEBUG && !IndexDebugProperties.IS_IN_STRESS_TESTS && (problem = this.getValueSerializationProblem(data, input)) != null) {
            this.myProblemReporter.reportProblem(problem);
        }
    }

    @Nullable
    private Exception getValueSerializationProblem(@NotNull Map<?, Value> data, @NotNull Input input) {
        for (Map.Entry<?, Value> e : data.entrySet()) {
            Value value = e.getValue();
            if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                return new Exception("Index " + this.myIndexId + " violates equals / hashCode contract for Value parameter");
            }
            try {
                Object deserializedValue;
                ByteArraySequence sequence = AbstractForwardIndexAccessor.serializeValueToByteSeq(value, this.myValueExternalizer, 4);
                Object object = deserializedValue = sequence == null ? null : (Object)this.myValueExternalizer.read(new DataInputStream(sequence.toInputStream()));
                if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                LOG.error("Index " + this.myIndexId + " deserialization violates equals / hashCode contract for Value parameter" + " while indexing " + input + ". Original value: '" + value + "'; Deserialized value: '" + deserializedValue + "'");
            }
            catch (IOException ex) {
                return ex;
            }
        }
        return null;
    }
}

