/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateData<Key, Value>
extends AbstractUpdateData<Key, Value> {
    private final Map<Key, Value> myNewData;
    private final ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> myCurrentDataEvaluator;
    private final IndexId<Key, Value> myIndexId;
    private final ThrowableRunnable<? extends IOException> myForwardIndexUpdate;

    public UpdateData(int inputId, @NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> currentDataEvaluator, @NotNull IndexId<Key, Value> indexId, @Nullable ThrowableRunnable<? extends IOException> forwardIndexUpdate) {
        super(inputId);
        this.myNewData = newData;
        this.myCurrentDataEvaluator = currentDataEvaluator;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    @Override
    protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        InputDataDiffBuilder currentData;
        try {
            currentData = (InputDataDiffBuilder)this.myCurrentDataEvaluator.compute();
        }
        catch (IOException e) {
            throw new StorageException("Error while applying " + this, e);
        }
        return currentData.differentiate(this.myNewData, addProcessor, updateProcessor, removeProcessor);
    }

    @Override
    protected void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return "update data for " + this.getInputId() + " of " + this.myIndexId;
    }
}

