/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.IndexStorageLayout;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueSerializationChecker;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    protected final IndexId<Key, Value> myIndexId;
    protected final IndexStorage<Key, Value> myStorage;
    protected final AtomicLong myModificationStamp = new AtomicLong();
    protected final DataIndexer<Key, Value, Input> myIndexer;
    @Nullable
    private final ValueSerializationChecker<Value, Input> myValueSerializationChecker;
    private final IndexExtension<Key, Value, Input> myExtension;
    @Nullable
    private final ForwardIndex myForwardIndex;
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    private final ReadWriteLock myLock;
    private final boolean myUseIntForwardIndex;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

        @Override
        public void process(Key key, int inputId) throws StorageException {
            MapReduceIndex.this.incrementModificationStamp();
            MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.incrementModificationStamp();
            MapReduceIndex.this.myStorage.addValue(key, inputId, value);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.incrementModificationStamp();
            MapReduceIndex.this.myStorage.updateValue(key, inputId, value);
        }
    };

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorageLayout<Key, Value> indexStorageLayout, @Nullable ReadWriteLock lock) throws IOException {
        this(extension, indexStorageLayout.openIndexStorage(), indexStorageLayout.openForwardIndex(), indexStorageLayout.getForwardIndexAccessor(), lock);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        this(extension, storage, forwardIndex, forwardIndexAccessor, null);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ReadWriteLock lock) throws IOException {
        this(extension, () -> storage, (ThrowableComputable<? extends ForwardIndex, ? extends IOException>)((ThrowableComputable)() -> forwardIndex), forwardIndexAccessor, lock);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storage, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ReadWriteLock lock) throws IOException {
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = (IndexStorage)storage.compute();
        try {
            this.myForwardIndex = forwardIndex == null ? null : (ForwardIndex)forwardIndex.compute();
        }
        catch (IOException e) {
            this.tryDispose();
            throw e;
        }
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = this.myForwardIndex instanceof IntForwardIndex && this.myForwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(this.myForwardIndex instanceof IntForwardIndex == this.myForwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration for " + this.myIndexId);
        this.myLock = lock == null ? new ReentrantReadWriteLock() : lock;
        this.myValueSerializationChecker = new ValueSerializationChecker(extension, this.getSerializationProblemReporter());
        this.myLowMemoryFlusher = LowMemoryWatcher.register(() -> this.clearCaches());
    }

    private void clearCaches() {
        try {
            this.myLock.readLock().lock();
            try {
                this.myStorage.clearCaches();
            }
            finally {
                this.myLock.readLock().unlock();
            }
            this.flush();
        }
        catch (Throwable e) {
            this.requestRebuild(e);
        }
    }

    @NotNull
    protected ValueSerializationProblemReporter getSerializationProblemReporter() {
        return ValueSerializationChecker.DEFAULT_SERIALIZATION_PROBLEM_REPORTER;
    }

    protected void tryDispose() {
        try {
            this.dispose();
        }
        catch (Exception e) {
            LOG.info(e);
        }
    }

    @Nullable
    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        return this.myExtension;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        return this.myStorage;
    }

    @NotNull
    public final ReadWriteLock getLock() {
        return this.myLock;
    }

    @Override
    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.incrementModificationStamp();
            this.doClear();
        }
        catch (StorageException | IOException e) {
            LOG.info(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.myLock.readLock().lock();
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        this.myLock.writeLock().lock();
        try {
            this.myDisposed = true;
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        this.myLock.readLock().lock();
        try {
            if (this.isDisposed()) {
                ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
                return valueContainerImpl;
            }
            IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
            ValueContainer<Value> valueContainer = this.myStorage.read(key);
            return valueContainer;
        }
        finally {
            IndexDebugProperties.DEBUG_INDEX_ID.set(null);
            this.myLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapReduceIndexMappingException, ProcessCanceledException {
        InputData<Key, Value> data;
        try {
            data = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException | MapReduceIndexMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapReduceIndexMappingException(e, this.myExtension.getClass());
        }
        return this.prepareUpdate(inputId, (InputData)data);
    }

    @NotNull
    public IndexUpdateComputable prepareUpdate(int inputId, @NotNull InputData<Key, Value> data) {
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, data.getKeyValues(), () -> this.getKeysDiffBuilder(inputId), this.myIndexId, (ThrowableRunnable<? extends IOException>)((ThrowableRunnable)() -> this.updateForwardIndex(inputId, data)));
        return new IndexUpdateComputable(updateData, data);
    }

    @ApiStatus.Internal
    protected void checkNonCancellableSection() {
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                ((IntForwardIndex)this.myForwardIndex).putInt(inputId, ((IntForwardIndexAccessor)this.myForwardIndexAccessor).serializeIndexedDataToInt(data));
            } else {
                this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data));
            }
        }
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                return ((IntForwardIndexAccessor)this.myForwardIndexAccessor).getDiffBuilderFromInt(inputId, ((IntForwardIndex)this.myForwardIndex).getInt(inputId));
            }
            return this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            return InputData.empty();
        }
        Map<Key, Value> data = this.mapByIndexer(inputId, content);
        if (this.myValueSerializationChecker != null) {
            this.myValueSerializationChecker.checkValueSerialization(data, content);
        }
        this.checkCanceled();
        return new InputData<Key, Value>(data);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        return this.myIndexer.map(content);
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    protected void incrementModificationStamp() {
        this.myModificationStamp.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        this.myLock.writeLock().lock();
        try {
            IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
            try {
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e) {
                LOG.error("ProcessCanceledException is not expected here!", e);
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @ApiStatus.Internal
    public class IndexUpdateComputable
    implements Computable<Boolean> {
        private final UpdateData<Key, Value> myUpdateData;
        private final InputData<Key, Value> myInputData;

        private IndexUpdateComputable(@NotNull UpdateData<Key, Value> updateData, InputData<Key, Value> inputData) {
            this.myUpdateData = updateData;
            this.myInputData = inputData;
        }

        @NotNull
        public InputData<Key, Value> getInputData() {
            return this.myInputData;
        }

        @Override
        public Boolean compute() {
            MapReduceIndex.this.checkNonCancellableSection();
            try {
                MapReduceIndex.this.updateWithMap(this.myUpdateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                String message = "An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName() + " will be rebuilt.";
                if (ex instanceof ProcessCanceledException) {
                    LOG.error(message, ex);
                } else if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                    LOG.error(message, ex);
                } else {
                    LOG.info(message, ex);
                }
                MapReduceIndex.this.requestRebuild(ex);
                return false;
            }
            return true;
        }
    }
}

