/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.CollectionDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class InputIndexDataExternalizer<K>
implements DataExternalizer<Collection<K>> {
    private final DataExternalizer<Collection<K>> myKeyCollectionExternalizer;
    private final IndexId<K, ?> myIndexId;

    public InputIndexDataExternalizer(KeyDescriptor<K> keyDescriptor, IndexId<K, ?> indexId) {
        this.myKeyCollectionExternalizer = new CollectionDataExternalizer<K>(keyDescriptor);
        this.myIndexId = indexId;
    }

    @Override
    public void save(@NotNull DataOutput out, @NotNull Collection<K> value) throws IOException {
        try {
            this.myKeyCollectionExternalizer.save(out, value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error saving data for index " + this.myIndexId, e);
        }
    }

    @Override
    @NotNull
    public Collection<K> read(@NotNull DataInput in) throws IOException {
        try {
            return this.myKeyCollectionExternalizer.read(in);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error reading data for index " + this.myIndexId, e);
        }
    }
}

