/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexStorageUtil {
    @NotNull
    public static <K, V> Map<K, V> createKeyDescriptorHashedMap(final @NotNull KeyDescriptor<? super K> keyDescriptor) {
        return new Object2ObjectOpenCustomHashMap(new Hash.Strategy<K>(){

            public int hashCode(@Nullable K o) {
                return o == null ? 0 : keyDescriptor.getHashCode(o);
            }

            public boolean equals(@Nullable K a, @Nullable K b) {
                return a == b || a != null && b != null && keyDescriptor.isEqual(a, b);
            }
        });
    }

    @NotNull
    public static <K> HashingStrategy<K> adaptKeyDescriptorToStrategy(final @NotNull KeyDescriptor<? super K> keyDescriptor) {
        return new HashingStrategy<K>(){

            @Override
            public int hashCode(@Nullable K o) {
                if (o == null) {
                    return 0;
                }
                return keyDescriptor.getHashCode(o);
            }

            @Override
            public boolean equals(@Nullable K a, @Nullable K b) {
                if (a == null && b != null) {
                    return false;
                }
                if (b == null && a != null) {
                    return false;
                }
                return keyDescriptor.isEqual(a, b);
            }
        };
    }
}

