/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EmptyInputDataDiffBuilder<Key, Value>
extends DirectInputDataDiffBuilder<Key, Value> {
    public EmptyInputDataDiffBuilder(int inputId) {
        super(inputId);
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() {
        return Collections.emptySet();
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        return EmptyInputDataDiffBuilder.processAllKeyValuesAsAdded(this.myInputId, newData, addProcessor);
    }

    public static <Key, Value> boolean processAllKeyValuesAsAdded(int inputId, @NotNull Map<Key, Value> addedData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor) throws StorageException {
        boolean anyAdded = false;
        for (Map.Entry<Key, Value> entry : addedData.entrySet()) {
            addProcessor.process(entry.getKey(), entry.getValue(), inputId);
            anyAdded = true;
        }
        return anyAdded;
    }

    public static <Key, Value> boolean processAllKeyValuesAsRemoved(int inputId, @NotNull Map<Key, Value> removedData, @NotNull RemovedKeyProcessor<? super Key> removedProcessor) throws StorageException {
        boolean anyRemoved = false;
        for (Key key : removedData.keySet()) {
            removedProcessor.process(key, inputId);
            anyRemoved = true;
        }
        return anyRemoved;
    }
}

