/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.IOCancellationCallbackHolder;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        IntOpenHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            IntOpenHashSet copy = new IntOpenHashSet();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                IntPredicate predicate;
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator.hasNext()) {
                        int id = iterator.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.test(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                        copy.add(id);
                    }
                    continue;
                }
                IntIterator intIterator = mainIntersection.iterator();
                while (intIterator.hasNext()) {
                    int id = intIterator.nextInt();
                    if (!predicate.test(id) || idChecker != null && !idChecker.test(id)) continue;
                    copy.add(id);
                }
            }
            mainIntersection = copy;
            if (!mainIntersection.isEmpty()) continue;
            return IntSets.EMPTY_SET;
        }
        return mainIntersection == null ? IntSets.EMPTY_SET : mainIntersection;
    }

    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAnyKey(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        IntOpenHashSet result = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                while (iterator.hasNext()) {
                    int id = iterator.next();
                    if (idChecker != null && !idChecker.test(id)) continue;
                    if (result == null) {
                        result = new IntOpenHashSet();
                    }
                    result.add(id);
                }
            }
        }
        return result == null ? IntSets.EMPTY_SET : result;
    }
}

