/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static volatile SimpleStringPersistentEnumerator ourNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<String, ID<?, ?>> ourIdObjects = new ConcurrentHashMap();
    private static final Map<ID<?, ?>, PluginId> ourIdToPluginId = Collections.synchronizedMap(new HashMap());
    private static final Map<ID<?, ?>, Throwable> ourIdToRegistrationStackTrace = Collections.synchronizedMap(new HashMap());
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private volatile int myUniqueId;

    @ApiStatus.Internal
    @NotNull
    private static Path getEnumFile() {
        return PathManager.getIndexRoot().resolve("indices.enum");
    }

    @ApiStatus.Internal
    public static void reloadEnumFile() {
        ID.reloadEnumFile(ID.getEnumFile());
    }

    private static void reloadEnumFile(@NotNull Path enumFile) {
        if (enumFile.equals(ourNameToIdRegistry.getFile())) {
            return;
        }
        SimpleStringPersistentEnumerator newNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
        Map<String, Integer> newInvertedState = newNameToIdRegistry.getInvertedState();
        Map<String, Integer> oldInvertedState = ourNameToIdRegistry.getInvertedState();
        oldInvertedState.forEach((oldKey, oldId) -> {
            Integer newId = (Integer)newInvertedState.get(oldKey);
            if (newId == null) {
                int createdId = newNameToIdRegistry.enumerate((String)oldKey);
                if (createdId != oldId) {
                    ID.reassign(oldKey, createdId);
                }
            } else if (oldId.intValue() != newId.intValue()) {
                ID.reassign(oldKey, newId);
            }
        });
        ourNameToIdRegistry = newNameToIdRegistry;
    }

    private static void reassign(String name, int newId) {
        ID<?, ?> id = ourIdObjects.get(name);
        if (id != null) {
            id.myUniqueId = newId;
        }
    }

    @ApiStatus.Internal
    protected ID(@NotNull String name, @Nullable PluginId pluginId) {
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = ourIdObjects.put(name, this);
        assert (old == null) : "ID with name '" + name + "' is already registered";
        PluginId oldPluginId = ourIdToPluginId.put(this, pluginId);
        assert (oldPluginId == null) : "ID with name '" + name + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
        ourIdToRegistrationStackTrace.put(this, new Throwable());
    }

    private static int stringToId(@NotNull String name) {
        int id = ourNameToIdRegistry.enumerate(name);
        if (id != (short)id) {
            throw new AssertionError((Object)"Too many indexes registered");
        }
        return id;
    }

    static void reinitializeDiskStorage() {
        ourNameToIdRegistry.forceDiskSync();
    }

    @NotNull
    public static synchronized <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        PluginId pluginId = ID.getCallerPluginId();
        ID<K, V> found = ID.findByName(name, true, pluginId);
        return found == null ? new ID<K, V>(name, pluginId) : found;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        return ID.findByName(name, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        ID<?, ?> id = ID.findById(ID.stringToId(name));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = ourIdToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "IJ Core" : actualPluginId.getIdString();
            String string2 = requiredPluginIdStr = requiredPluginId == null ? "IJ Core" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = ourIdToRegistrationStackTrace.get(id);
                String message = ID.getInvalidIdAccessMessage(name, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace != null) {
                    throw new AssertionError(message, registrationStackTrace);
                }
                throw new AssertionError((Object)message);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        return "ID with name '" + name + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
    }

    @ApiStatus.Internal
    public static Collection<ID<?, ?>> getRegisteredIds() {
        return Collections.unmodifiableSet(new HashSet(ourIdToPluginId.keySet()));
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        return ourIdToRegistrationStackTrace.get(this);
    }

    @ApiStatus.Internal
    public int getUniqueId() {
        return this.myUniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return ourIdToPluginId.get(this);
    }

    @ApiStatus.Internal
    public static ID<?, ?> findById(int id) {
        String key = ourNameToIdRegistry.valueOf(id);
        return key == null ? null : ourIdObjects.get(key);
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    @ApiStatus.Internal
    public static synchronized void unloadId(@NotNull ID<?, ?> id) {
        ID<?, ?> oldID = ourIdObjects.remove(id.getName());
        LOG.assertTrue(id.equals(oldID));
        ourIdToPluginId.remove(id);
        ourIdToRegistrationStackTrace.remove(id);
    }
}

