/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.ArrayBackedFMap;
import com.intellij.util.fmap.FMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MapBackedFMap<@NotNull K, @NotNull V>
implements FMap<K, V> {
    @NotNull
    private final Map<K, V> myMap;

    MapBackedFMap(@NotNull Map<K, V> map) {
        assert (map.size() > 8);
        this.myMap = map;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        if (value.equals(this.myMap.get(key))) {
            return this;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(this.myMap);
        newMap.put(key, value);
        return new MapBackedFMap<K, V>(newMap);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        if (!this.myMap.containsKey(key)) {
            return this;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(this.myMap);
        newMap.remove(key);
        if (newMap.size() > 8) {
            return new MapBackedFMap<K, V>(newMap);
        }
        return new ArrayBackedFMap<K, V>(newMap);
    }

    @Override
    @Nullable
    public V get(K key) {
        return this.myMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        return Collections.unmodifiableSet(this.myMap.keySet());
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        return Collections.unmodifiableMap(this.myMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBackedFMap map = (MapBackedFMap)o;
        return this.myMap.equals(map.myMap);
    }

    public int hashCode() {
        return Objects.hash(this.myMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Map.Entry<K, V> entry : this.myMap.entrySet()) {
            sb.append("  ").append(entry.getKey()).append(": ").append(entry.getValue()).append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

