/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class WeakHashSet<T>
extends AbstractSet<T> {
    private final Set<MyRef<T>> set = new HashSet<MyRef<T>>();
    private final ReferenceQueue<T> queue = new ReferenceQueue();

    WeakHashSet() {
    }

    @Override
    public Iterator<T> iterator() {
        return ContainerUtil.filterIterator(ContainerUtil.mapIterator(this.set.iterator(), Reference::get), Objects::nonNull);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(@NotNull T t) {
        this.processQueue();
        MyRef<T> ref = new MyRef<T>(t, this.queue);
        return this.set.add(ref);
    }

    @Override
    public boolean remove(@NotNull Object o) {
        this.processQueue();
        return this.set.remove(new HardRef<Object>(o));
    }

    @Override
    public boolean contains(@NotNull Object o) {
        this.processQueue();
        return this.set.contains(new HardRef<Object>(o));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private void processQueue() {
        MyRef ref;
        while ((ref = (MyRef)this.queue.poll()) != null) {
            this.set.remove(ref);
        }
    }

    private static class HardRef<T>
    extends MyRef<T> {
        HardRef(@NotNull T referent) {
            super(referent, null);
        }
    }

    private static class MyRef<T>
    extends WeakReference<T> {
        private final int myHashCode;

        MyRef(@NotNull T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.myHashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef otherRef = (MyRef)obj;
            if (this instanceof HardRef || otherRef instanceof HardRef) {
                return Comparing.equal(otherRef.get(), this.get());
            }
            return this == obj;
        }
    }
}

