/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class UnsafeWeakList<T>
extends AbstractCollection<T> {
    protected final List<MyReference<T>> myList;
    private final ReferenceQueue<T> myQueue = new ReferenceQueue();
    private int myAlive;
    private int modCount;

    public UnsafeWeakList() {
        this.myList = new ArrayList<MyReference<T>>();
    }

    public UnsafeWeakList(int capacity) {
        this.myList = new ArrayList<MyReference<T>>(capacity);
    }

    boolean processQueue() {
        MyReference reference;
        boolean processed = false;
        while ((reference = (MyReference)this.myQueue.poll()) != null) {
            int index = reference.index;
            if (index < this.myList.size() && reference == this.myList.get(index)) {
                this.nullizeAt(index);
            }
            processed = true;
        }
        if (this.myAlive < this.myList.size() / 2) {
            this.reduceCapacity();
        }
        return processed;
    }

    private void nullizeAt(int index) {
        this.myList.set(index, null);
        --this.myAlive;
    }

    private void reduceCapacity() {
        int toSaveAlive = 0;
        for (int i = 0; i < this.myList.size(); ++i) {
            MyReference<T> reference = this.myList.get(i);
            if (reference == null) continue;
            Object t = reference.get();
            if (t == null) {
                --this.myAlive;
                continue;
            }
            if (toSaveAlive != i) {
                this.myList.set(toSaveAlive, new MyReference(toSaveAlive, t, this.myQueue));
            }
            ++toSaveAlive;
        }
        if (toSaveAlive != this.myList.size()) {
            this.myList.subList(toSaveAlive, this.myList.size()).clear();
            ++this.modCount;
        }
        this.myAlive = toSaveAlive;
    }

    private void append(@NotNull T element) {
        this.myList.add(new MyReference(this.myList.size(), element, this.myQueue));
        ++this.myAlive;
        ++this.modCount;
    }

    @Override
    public boolean add(@NotNull T element) {
        this.processQueue();
        this.append(element);
        return true;
    }

    public boolean addIfAbsent(@NotNull T element) {
        this.processQueue();
        if (this.contains(element)) {
            return false;
        }
        this.append(element);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return !this.isEmpty() && super.contains(o);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myList.clear();
        this.myAlive = 0;
        ++this.modCount;
    }

    @TestOnly
    int listSize() {
        return this.myList.size();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull T> iterator() {
        return new MyIterator();
    }

    @Override
    public boolean remove(@NotNull Object o) {
        this.processQueue();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object t;
            Reference ref = this.myList.get(i);
            Object object = t = ref == null ? null : (Object)ref.get();
            if (t == null || !t.equals(o)) continue;
            this.nullizeAt(i);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        this.processQueue();
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        this.processQueue();
        return super.removeAll(c);
    }

    @NotNull
    public @NotNull List<@NotNull T> toStrongList() {
        if (this.myList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.myList.size());
        for (MyReference<T> t : this.myList) {
            Object o = t == null ? null : (Object)t.get();
            if (o == null) continue;
            result.add(o);
        }
        return result;
    }

    @Override
    @Deprecated
    public int size() {
        UnsafeWeakList.throwNotAllowedException();
        return -1;
    }

    private static void throwNotAllowedException() {
        throw new UnsupportedOperationException("index/size-based operations in UnsafeWeakList are not supported because they don't make sense in the presence of weak references. Use .iterator() (which retains its elements to avoid sudden GC) instead.");
    }

    @Override
    public boolean isEmpty() {
        if (this.myList.isEmpty()) {
            return true;
        }
        for (MyReference<T> value : this.myList) {
            if (value == null || value.get() == null) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public T get(int index) {
        UnsafeWeakList.throwNotAllowedException();
        return null;
    }

    public boolean containsAll(@NotNull UnsafeWeakList<T> other, @NotNull Predicate<? super T> allowEntity) {
        List<MyReference<T>> myList = this.myList;
        List<MyReference<T>> otherList = other.myList;
        if (otherList.isEmpty()) {
            return true;
        }
        for (MyReference<T> otherReference : otherList) {
            T t = SoftReference.dereference(otherReference);
            if (t == null || !allowEntity.test(t) || myList.contains(otherReference)) continue;
            return false;
        }
        return true;
    }

    private final class MyIterator
    implements Iterator<T> {
        private final int startModCount;
        private int curIndex;
        private T curElement;
        private int nextIndex = -1;
        private T nextElement;
        private boolean modified;

        private MyIterator() {
            this.startModCount = UnsafeWeakList.this.modCount;
            this.findNext();
        }

        private void findNext() {
            if (UnsafeWeakList.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            this.curIndex = this.nextIndex;
            this.curElement = this.nextElement;
            this.nextElement = null;
            this.nextIndex = -1;
            for (int i = this.curIndex + 1; i < UnsafeWeakList.this.myList.size(); ++i) {
                Object t;
                Reference ref = UnsafeWeakList.this.myList.get(i);
                Object v0 = t = ref == null ? null : ref.get();
                if (t == null) continue;
                this.nextElement = t;
                this.nextIndex = i;
                break;
            }
            if (this.nextIndex == -1 && this.modified) {
                UnsafeWeakList.this.modCount++;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return this.curElement;
        }

        @Override
        public void remove() {
            if (this.curElement == null) {
                throw new NoSuchElementException();
            }
            int index = this.curIndex;
            UnsafeWeakList.this.nullizeAt(index);
            this.modified = true;
        }
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int index;

        private MyReference(int index, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.index = index;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && Objects.equals(this.get(), ((Reference)obj).get());
        }
    }
}

