/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Deprecated
public class TransferToEDTQueue<T> {
    private static final int DEFAULT_THRESHOLD = 30;
    private final String myName;
    private final Processor<? super T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Deque<T> myQueue = new ArrayDeque<T>(10);
    private final AtomicBoolean invokeLaterScheduled = new AtomicBoolean();
    private final Runnable myUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
            assert (b);
            if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                TransferToEDTQueue.this.stop();
                return;
            }
            long start = System.currentTimeMillis();
            while (TransferToEDTQueue.this.processNext()) {
                long finish = System.currentTimeMillis();
                if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                break;
            }
            if (!TransferToEDTQueue.this.isEmpty()) {
                TransferToEDTQueue.this.scheduleUpdate();
            }
        }

        public String toString() {
            return TransferToEDTQueue.this.getClass().getSimpleName() + "[" + TransferToEDTQueue.this.myName + "]";
        }
    };

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<? super T> processor, @NotNull Condition<?> shutUpCondition) {
        this(name, processor, shutUpCondition, 30);
    }

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<? super T> processor, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        this.myName = name;
        this.myProcessor = processor;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name) {
        return TransferToEDTQueue.createRunnableMerger(name, 30);
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name, int maxUnitOfWorkThresholdMs) {
        return new TransferToEDTQueue<Runnable>(name, runnable -> {
            runnable.run();
            return true;
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pollFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pollFirst() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(@NotNull T thing) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(@NotNull T thing) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            boolean absent;
            boolean bl = absent = !this.myQueue.contains(thing);
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public Collection<T> dump() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return new ArrayList<T>(this.myQueue);
        }
    }

    public void drain() {
        int processed = 0;
        while (this.processNext()) {
            ++processed;
        }
    }

    public void waitFor() {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.schedule(semaphore::up);
        semaphore.waitFor();
    }
}

