/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.SingletonIteratorBase;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartHashSet<T>
extends HashSet<T> {
    private T theElement;

    public SmartHashSet() {
    }

    public SmartHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public SmartHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection) {
        super(collection.size() == 1 ? Collections.emptyList() : collection);
        if (collection.size() == 1) {
            T element = collection.iterator().next();
            if (element == null) {
                throw new IllegalArgumentException("Null elements are not permitted but got: " + collection);
            }
            this.theElement = element;
        }
    }

    @Override
    public boolean contains(@NotNull Object obj) {
        T theElement = this.theElement;
        if (theElement != null) {
            return Objects.equals(obj, theElement);
        }
        return !super.isEmpty() && super.contains(obj);
    }

    @Override
    public boolean add(@NotNull T obj) {
        T theElement = this.theElement;
        if (theElement != null) {
            if (Objects.equals(obj, theElement)) {
                return false;
            }
            super.add(this.theElement);
            this.theElement = null;
            return super.add(obj);
        }
        if (super.isEmpty()) {
            this.theElement = obj;
            return true;
        }
        return super.add(obj);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        T theElement = this.theElement;
        if (theElement != null) {
            return other instanceof Set && ((Set)other).size() == 1 && Objects.equals(((Set)other).iterator().next(), theElement);
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        T theElement = this.theElement;
        return theElement == null ? super.hashCode() : theElement.hashCode();
    }

    @Override
    public void clear() {
        this.theElement = null;
        super.clear();
    }

    @Override
    public int size() {
        return this.theElement == null ? super.size() : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.theElement == null && super.isEmpty();
    }

    @Override
    public boolean remove(@NotNull Object obj) {
        T theElement = this.theElement;
        if (theElement == null) {
            return super.remove(obj);
        }
        if (Objects.equals(obj, theElement)) {
            this.theElement = null;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (this.theElement == null) {
            return super.iterator();
        }
        return new SingletonIteratorBase<T>(){

            @Override
            protected void checkCoModification() {
                if (SmartHashSet.this.theElement == null) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            protected T getElement() {
                return SmartHashSet.this.theElement;
            }

            @Override
            public void remove() {
                this.checkCoModification();
                SmartHashSet.this.clear();
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        T theElement = this.theElement;
        if (theElement == null) {
            super.forEach(action);
        } else {
            action.accept(theElement);
        }
    }

    @Override
    public Object @NotNull [] toArray() {
        T theElement = this.theElement;
        if (theElement == null) {
            return super.toArray();
        }
        return new Object[]{theElement};
    }

    @Override
    public <O> O @NotNull [] toArray(O @NotNull [] a) {
        T theElement = this.theElement;
        if (theElement == null) {
            return super.toArray(a);
        }
        if (a.length == 0) {
            a = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
        }
        a[0] = theElement;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public Stream<T> stream() {
        return this.theElement == null ? super.stream() : Stream.of(this.theElement);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.theElement == null ? super.spliterator() : Stream.of(this.theElement).spliterator();
    }
}

