/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

final class SequenceIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T>[] myIterators;
    private int myCurrentIndex;

    @SafeVarargs
    SequenceIterator(Iterator<? extends T> ... iterators) {
        this.myIterators = (Iterator[])iterators.clone();
    }

    SequenceIterator(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        this(iterators.toArray(new Iterator[0]));
    }

    @Override
    public boolean hasNext() {
        for (int index = this.myCurrentIndex; index < this.myIterators.length; ++index) {
            Iterator<T> iterator = this.myIterators[index];
            if (iterator == null || !iterator.hasNext()) continue;
            this.myCurrentIndex = index;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.myIterators[this.myCurrentIndex].next();
        }
        throw new NoSuchElementException("Iterator has no more elements");
    }

    @Override
    public void remove() {
        if (this.myCurrentIndex >= this.myIterators.length) {
            throw new IllegalStateException();
        }
        this.myIterators[this.myCurrentIndex].remove();
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<? extends T> first, @NotNull Iterator<? extends T> second) {
        return new SequenceIterator<T>(first, second);
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<? extends T> first, @NotNull Iterator<? extends T> second, @NotNull Iterator<? extends T> third) {
        return new SequenceIterator<T>(first, second, third);
    }
}

