/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;

    public RecentStringInterner(@NotNull Disposable parentDisposable) {
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        int capacity = 8192;
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myInterns[i] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @NotNull
                public String createValue(String key) {
                    return key;
                }

                protected void putToProtectedQueue(String key, @NotNull String value) {
                    super.putToProtectedQueue((Object)value, (Object)value);
                }
            };
            this.myStripeLocks[i] = new ReentrantLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        LowMemoryWatcher.register(this::clear, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="null -> null")
    public String get(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        this.myStripeLocks[stripe].lock();
        try {
            String string2 = (String)this.myInterns[stripe].get((Object)s);
            return string2;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    public void clear() {
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myStripeLocks[i].lock();
            try {
                this.myInterns[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }
}

