/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class PeekableIteratorWrapper<T>
implements PeekableIterator<T> {
    @NotNull
    private final Iterator<? extends T> myIterator;
    private T myValue = null;
    private boolean myValidValue = false;

    public PeekableIteratorWrapper(@NotNull Iterator<? extends T> iterator) {
        this.myIterator = iterator;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.myValidValue;
    }

    @Override
    public T next() {
        if (this.myValidValue) {
            T save = this.myValue;
            this.advance();
            return save;
        }
        throw new NoSuchElementException();
    }

    @Override
    public T peek() {
        if (this.myValidValue) {
            return this.myValue;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advance() {
        this.myValidValue = this.myIterator.hasNext();
        this.myValue = this.myValidValue ? this.myIterator.next() : null;
    }
}

