/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="myMap.entrySet().toArray()")
public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784473565881807109L;
    protected final Map<K, Object> myMap;

    public MostlySingularMultiMap() {
        this.myMap = CollectionFactory.createSmallMemoryFootprintMap();
    }

    public MostlySingularMultiMap(@NotNull Map<K, Object> map) {
        this.myMap = map;
    }

    public void add(@NotNull K key, @NotNull V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof ValueList) {
            ((List)current).add(value);
        } else {
            ValueList newList = new ValueList();
            newList.add(current);
            newList.add(value);
            this.myMap.put(key, newList);
        }
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return false;
        }
        if (current instanceof ValueList) {
            return ((List)current).remove(value);
        }
        if (value.equals(current)) {
            this.myMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeAllValues(@NotNull K key) {
        return this.myMap.remove(key) != null;
    }

    @NotNull
    public final Set<K> keySet() {
        return this.myMap.keySet();
    }

    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public final boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (v instanceof ValueList) {
            for (Object o : (ValueList)v) {
                if (p.process(o)) continue;
                return false;
            }
            return true;
        }
        return v == null || p.process(v);
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public final int size() {
        return this.myMap.size();
    }

    public final boolean containsKey(@NotNull K key) {
        return this.myMap.containsKey(key);
    }

    public final int valuesForKey(@NotNull K key) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return 0;
        }
        if (current instanceof ValueList) {
            return ((ValueList)current).size();
        }
        return 1;
    }

    @NotNull
    public final Iterable<V> get(@NotNull K name) {
        return this.rawValueToCollection(this.myMap.get(name));
    }

    @NotNull
    protected final List<V> rawValueToCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof ValueList) {
            return (ValueList)value;
        }
        return Collections.singletonList(value);
    }

    public void compact() {
        CollectionFactory.trimMap(this.myMap);
        for (Object eachValue : this.myMap.values()) {
            if (!(eachValue instanceof ValueList)) continue;
            ((ValueList)eachValue).trimToSize();
        }
    }

    public final String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), entry -> {
            Object value = entry.getValue();
            String s = (value instanceof ValueList ? value : Collections.singletonList(value)).toString();
            return entry.getKey() + ": " + s;
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        return EmptyMap.EMPTY;
    }

    public void addAll(@NotNull MostlySingularMultiMap<K, V> other) {
        if (other.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Object> entry : other.myMap.entrySet()) {
            K key = entry.getKey();
            Object otherValue = entry.getValue();
            Object myValue = this.myMap.get(key);
            if (myValue == null) {
                if (otherValue instanceof ValueList) {
                    this.myMap.put(key, new ValueList((ValueList)otherValue));
                    continue;
                }
                this.myMap.put(key, otherValue);
                continue;
            }
            if (myValue instanceof ValueList) {
                ValueList myListValue = (ValueList)myValue;
                if (otherValue instanceof ValueList) {
                    myListValue.addAll((ValueList)otherValue);
                    continue;
                }
                myListValue.add(otherValue);
                continue;
            }
            if (otherValue instanceof ValueList) {
                ValueList otherListValue = (ValueList)otherValue;
                ValueList newList = new ValueList(otherListValue.size() + 1);
                newList.add(myValue);
                newList.addAll(otherListValue);
                this.myMap.put(key, newList);
                continue;
            }
            ValueList newList = new ValueList();
            newList.add(myValue);
            newList.add(otherValue);
            this.myMap.put(key, newList);
        }
    }

    @NotNull
    public static Class<? extends List<?>> getValueListClass() {
        return ValueList.class;
    }

    @NotNull
    public static List<?> createValueList() {
        return new ValueList();
    }

    private static final class EmptyMap
    extends MostlySingularMultiMap<Object, Object> {
        static final MostlySingularMultiMap<?, ?> EMPTY = new EmptyMap();

        private EmptyMap() {
            super(Collections.emptyMap());
        }

        @Override
        public void add(@NotNull Object key, @NotNull Object value) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean remove(@NotNull Object key, @NotNull Object value) {
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }
    }

    protected static final class ValueList<V>
    extends ArrayList<V> {
        public ValueList() {
        }

        public ValueList(int initialCapacity) {
            super(initialCapacity);
        }

        public ValueList(@NotNull Collection<? extends V> c) {
            super(c);
        }
    }
}

