/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.CanonicalHashingStrategy;
import com.intellij.util.containers.CaseInsensitiveCharSequenceHashingStrategy;
import com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.containers.IdentityHashingStrategy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface HashingStrategy<T> {
    public int hashCode(T var1);

    public boolean equals(T var1, T var2);

    @NotNull
    public static <T> HashingStrategy<T> canonical() {
        return CanonicalHashingStrategy.INSTANCE;
    }

    @NotNull
    public static <T> HashingStrategy<T> identity() {
        return IdentityHashingStrategy.INSTANCE;
    }

    @NotNull
    public static HashingStrategy<String> caseInsensitive() {
        return CaseInsensitiveStringHashingStrategy.INSTANCE;
    }

    @NotNull
    public static HashingStrategy<CharSequence> caseInsensitiveCharSequence() {
        return CaseInsensitiveCharSequenceHashingStrategy.INSTANCE;
    }
}

