/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCollectionFactory {
    private static final HashingStrategy<File> FILE_HASH_STRATEGY = new SerializableHashingStrategy<File>(){

        @Override
        public int hashCode(@Nullable File o) {
            return FileUtilRt.pathHashCode((String)(o == null ? null : o.getPath()));
        }

        @Override
        public boolean equals(@Nullable File a, @Nullable File b) {
            return FileUtilRt.pathsEqual((String)(a == null ? null : a.getPath()), (String)(b == null ? null : b.getPath()));
        }
    };
    public static final HashingStrategy<String> FILE_PATH_HASH_STRATEGY = new HashingStrategy<String>(){

        @Override
        public int hashCode(@Nullable String o) {
            return FileUtilRt.pathHashCode((String)o);
        }

        @Override
        public boolean equals(@Nullable String p1, @Nullable String p2) {
            return FileUtilRt.pathsEqual((String)p1, (String)p2);
        }
    };

    @NotNull
    public static <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<String>(){

            public int hashCode(@Nullable String value) {
                return FileUtilRt.pathHashCode((String)value);
            }

            public boolean equals(@Nullable String val1, @Nullable String val2) {
                return FileUtilRt.pathsEqual((String)val1, (String)val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return CollectionFactory.createCustomHashingStrategyMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(int expected) {
        return CollectionFactory.createCustomHashingStrategyMap(expected, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map) {
        Map<File, V> result = FileCollectionFactory.createCanonicalFileMap(map.size());
        result.putAll(map);
        return result;
    }

    @NotNull
    public static Set<File> createCanonicalFileSet() {
        return CollectionFactory.createCustomHashingStrategySet(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files2) {
        Set<File> set = FileCollectionFactory.createCanonicalFileSet();
        set.addAll(files2);
        return set;
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files2) {
        return new ObjectOpenCustomHashSet(files2, (Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<File>(){

            public int hashCode(@Nullable File o) {
                return FileUtilRt.pathHashCode((String)(o == null ? null : o.getPath()));
            }

            public boolean equals(@Nullable File a, @Nullable File b) {
                return FileUtilRt.pathsEqual((String)(a == null ? null : a.getPath()), (String)(b == null ? null : b.getPath()));
            }
        });
    }

    private static final class PathSerializableHashStrategy
    implements FastUtilHashingStrategies.SerializableHashStrategy<Path> {
        private PathSerializableHashStrategy() {
        }

        public int hashCode(@Nullable Path o) {
            return FileUtilRt.pathHashCode((String)(o == null ? null : o.toString()));
        }

        public boolean equals(@Nullable Path a, @Nullable Path b) {
            return FileUtilRt.pathsEqual((String)(a == null ? null : a.toString()), (String)(b == null ? null : b.toString()));
        }
    }

    private static interface SerializableHashingStrategy<T>
    extends HashingStrategy<T>,
    Serializable {
    }
}

