/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.HashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class ConcurrentWeakKeyWeakValueHashMap<K, V>
extends ConcurrentWeakKeySoftValueHashMap<K, V> {
    ConcurrentWeakKeyWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> keyReference = new ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof WeakValue) {
            ((WeakValue)valueReference).myKeyReference = keyReference;
        }
        ObjectUtilsRt.reachabilityFence(k);
        return keyReference;
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
        return new WeakValue(value, queue);
    }

    private static final class WeakValue<K, V>
    extends WeakReference<V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        @NotNull
        private volatile ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> myKeyReference;

        private WeakValue(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
            super(value, queue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ConcurrentWeakKeySoftValueHashMap.ValueReference)o).get();
            return v != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            return this.myKeyReference;
        }
    }
}

