/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
HashingStrategy<K> {
    final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private final ConcurrentMap<KeyReference<K>, V> myMap;
    @NotNull
    private final HashingStrategy<? super K> myHashingStrategy;
    private static final float LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CAPACITY = 16;
    static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private static final HashingStrategy<?> THIS = new HashingStrategy<Object>(){

        @Override
        public int hashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey<?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());
    private Set<Map.Entry<K, V>> entrySet;

    @NotNull
    abstract KeyReference<K> createKeyReference(@NotNull K var1, @NotNull HashingStrategy<? super K> var2);

    @NotNull
    private KeyReference<K> createKeyReference(@NotNull K key) {
        return this.createKeyReference(key, this.myHashingStrategy);
    }

    private boolean processQueue() {
        KeyReference wk;
        boolean processed = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            this.myMap.remove(wk);
            processed = true;
        }
        return processed;
    }

    ConcurrentRefHashMap() {
        this(16);
    }

    private ConcurrentRefHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    private ConcurrentRefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, DEFAULT_CONCURRENCY_LEVEL, THIS);
    }

    ConcurrentRefHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        this(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL, hashingStrategy);
    }

    ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @Nullable HashingStrategy<? super K> hashingStrategy) {
        this.myHashingStrategy = hashingStrategy == THIS ? this : (hashingStrategy == null ? HashingStrategy.canonical() : hashingStrategy);
        this.myMap = new ConcurrentHashMap<KeyReference<K>, V>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(@NotNull Object key) {
        if (this.myMap.isEmpty()) {
            return false;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            boolean bl = this.myMap.containsKey(hardKey);
            return bl;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @NotNull
    private HardKey<K> createHardKey(@NotNull Object o) {
        Object key = o;
        HardKey<?> hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.hashCode(key));
        return hardKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (this.myMap.isEmpty()) {
            return null;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.get(hardKey);
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        KeyReference<K> weakKey = this.createKeyReference(key);
        V prev = this.myMap.put(weakKey, value);
        this.processQueue();
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@NotNull Object key) {
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.remove(hardKey);
            return v;
        }
        finally {
            this.processQueue();
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        return es;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V prev = this.myMap.putIfAbsent(this.createKeyReference(key), value);
        this.processQueue();
        return prev;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        boolean removed = this.myMap.remove(this.createKeyReference(key), value);
        this.processQueue();
        return removed;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        boolean replaced = this.myMap.replace(this.createKeyReference(key), oldValue, newValue);
        this.processQueue();
        return replaced;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        V replaced = this.myMap.replace(this.createKeyReference(key), value);
        this.processQueue();
        return replaced;
    }

    @Override
    public int hashCode(@Nullable K object) {
        int h = object == null ? 0 : object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    @Override
    public boolean equals(K o1, K o2) {
        return Objects.equals(o1, o2);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<KeyReference<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<KeyReference<K>, V>> hashIterator;
                private RefEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        KeyReference wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new RefEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RefEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentRefHashMap.this.createHardKey(e.getKey());
            try {
                Object hv = ConcurrentRefHashMap.this.myMap.get(key);
                boolean bl = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
                if (toRemove) {
                    ConcurrentRefHashMap.this.myMap.remove(key);
                }
            }
            finally {
                key.clear();
            }
            ConcurrentRefHashMap.this.processQueue();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                KeyReference wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static final class RefEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        RefEntry(@NotNull Map.Entry<?, V> ent, @Nullable K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(@NotNull V value) {
            return this.ent.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.key, e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<K>
    implements KeyReference<K> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private void clear() {
            this.setKey(null, 0);
        }
    }

    @FunctionalInterface
    static interface KeyReference<K> {
        public K get();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

