/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentMostlySingularMultiMap<K, V>
extends MostlySingularMultiMap<K, V> {
    public ConcurrentMostlySingularMultiMap() {
        super(new ConcurrentHashMap());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(@NotNull K key, @NotNull V value) {
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        while (true) {
            Object current;
            if ((current = map.get(key)) == null) {
                if (ConcurrencyUtil.cacheOrGet(map, key, value) != value) continue;
                return;
            }
            if (current instanceof MostlySingularMultiMap.ValueList) {
                MostlySingularMultiMap.ValueList curList = (MostlySingularMultiMap.ValueList)current;
                MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList(curList.size() + 1);
                newList.addAll(curList);
                newList.add(value);
                if (!map.replace(key, curList, newList)) continue;
                return;
            }
            MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList(2);
            newList.add(current);
            newList.add(value);
            if (map.replace(key, current, newList)) return;
        }
    }

    @Override
    public void compact() {
    }

    public boolean replace(@NotNull K key, @NotNull Collection<? extends V> expectedValue, @NotNull Collection<? extends V> newValue) {
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        MostlySingularMultiMap.ValueList<? extends V> newValueToPut = newValue.isEmpty() ? null : (newValue.size() == 1 ? newValue.iterator().next() : new MostlySingularMultiMap.ValueList<V>(newValue));
        Object oldValue = map.get(key);
        List oldCollection = this.rawValueToCollection(oldValue);
        if (!oldCollection.equals(expectedValue)) {
            return false;
        }
        if (oldValue == null) {
            return newValueToPut == null || map.putIfAbsent(key, newValueToPut) == null;
        }
        if (newValueToPut == null) {
            return map.remove(key, oldValue);
        }
        return map.replace(key, oldValue, newValueToPut);
    }

    @Override
    public void addAll(@NotNull MostlySingularMultiMap<K, V> other) {
        throw new AbstractMethodError("Not yet re-implemented for concurrency");
    }

    @Override
    public boolean remove(@NotNull K key, @NotNull V value) {
        throw new AbstractMethodError("Not yet re-implemented for concurrency");
    }
}

