/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.SimpleEntry;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentIntKeyRefValueHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectHashMap<IntReference<V>> myMap = new ConcurrentIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentIntKeyRefValueHashMap() {
    }

    @NotNull
    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, @NotNull ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, (Object)ref);
        }
        return;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        Object result;
        block3: {
            IntReference<V> ref;
            boolean replaced;
            IntReference<V> newRef = this.createReference(key, value, this.myQueue);
            do {
                if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                    result = value;
                } else {
                    Object old = ref.get();
                    if (old == null) continue;
                    result = old;
                }
                break block3;
            } while (!(replaced = this.myMap.replace(key, ref, newRef)));
            result = value;
        }
        this.processQueue();
        return result;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        boolean removed = this.myMap.remove(key, (Object)this.createReference(key, value, this.myQueue));
        this.processQueue();
        return removed;
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        boolean replaced = this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
        this.processQueue();
        return replaced;
    }

    @Override
    public V put(int key, @NotNull V value) {
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        this.processQueue();
        return SoftReference.deref(ref);
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return SoftReference.deref(ref);
    }

    @Override
    public V remove(int key) {
        IntReference<V> ref = this.myMap.remove(key);
        this.processQueue();
        return SoftReference.deref(ref);
    }

    @NotNull
    private static IncorrectOperationException pointlessContainsKey() {
        return new IncorrectOperationException("containsKey() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @NotNull
    private static IncorrectOperationException pointlessContainsValue() {
        return new IncorrectOperationException("containsValue() makes no sense for weak/soft map because GC can clear the key any moment now");
    }

    @Override
    public boolean containsKey(int key) {
        throw ConcurrentIntKeyRefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        throw ConcurrentIntKeyRefValueHashMap.pointlessContainsValue();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int @NotNull [] keys() {
        return this.myMap.keys();
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        final Iterator entryIterator = this.myMap.entrySet().iterator();
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private IntObjectMap.Entry<IntReference<V>> nextReferenceEntry;
            private IntObjectMap.Entry<IntReference<V>> lastReturned;
            {
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result = this.nextVEntry;
                this.lastReturned = this.nextReferenceEntry;
                this.nextAliveEntry();
                return result;
            }

            private void nextAliveEntry() {
                while (entryIterator.hasNext()) {
                    IntObjectMap.Entry entry = (IntObjectMap.Entry)entryIterator.next();
                    Object v = ((IntReference)entry.getValue()).get();
                    if (v == null) continue;
                    int key = entry.getKey();
                    this.nextVEntry = new SimpleEntry(key, v);
                    this.nextReferenceEntry = entry;
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntObjectMap.Entry last = this.lastReturned;
                if (last == null) {
                    throw new NoSuchElementException();
                }
                ConcurrentIntKeyRefValueHashMap.this.myMap.replaceNode(last.getKey(), null, last.getValue());
            }
        };
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        return new Enumeration<V>(){
            private V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result = (IntReference)elementRefs.nextElement();
                    Object v = result.get();
                    if (v == null) continue;
                    return v;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = this.findNextRef();
                return v;
            }
        };
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        Object prev;
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        while (true) {
            IntReference<V> oldRef;
            if ((oldRef = this.myMap.putIfAbsent(key, newRef)) == null) {
                prev = null;
                break;
            }
            Object oldVal = oldRef.get();
            if (oldVal == null) {
                if (this.myMap.replace(key, oldRef, newRef)) {
                    prev = null;
                    break;
                }
            } else {
                prev = oldVal;
                break;
            }
            this.processQueue();
        }
        this.processQueue();
        return prev;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        HashSet<V> result = new HashSet<V>();
        Enumeration<V> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    private final class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            return ConcurrentIntKeyRefValueHashMap.this.entriesIterator();
        }

        @Override
        public int size() {
            return ConcurrentIntKeyRefValueHashMap.this.size();
        }
    }

    static interface IntReference<V>
    extends Supplier<V> {
        public int getKey();
    }
}

