/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConcurrentFactoryMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, V> myMap = this.createMap();

    private ConcurrentFactoryMap() {
    }

    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        ConcurrentMap<K, V> map = this.myMap;
        Object k = ConcurrentFactoryMap.notNull(key);
        Object value = map.get(k);
        if (value == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = ConcurrentFactoryMap.notNull(value);
                value = ConcurrencyUtil.cacheOrGet(map, k, v);
            }
        }
        return ConcurrentFactoryMap.nullize(value);
    }

    @Nullable
    private static <T> T nullize(T value) {
        return value == ConcurrentFactoryMap.FAKE_NULL() ? null : (T)value;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? ConcurrentFactoryMap.FAKE_NULL() : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap.containsKey(ConcurrentFactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value) {
        Object k = ConcurrentFactoryMap.notNull(key);
        Object v = ConcurrentFactoryMap.notNull(value);
        v = this.myMap.put(k, v);
        return (V)ConcurrentFactoryMap.nullize(v);
    }

    @Override
    public V remove(Object key) {
        Object v = this.myMap.remove(ConcurrentFactoryMap.notNull(key));
        return ConcurrentFactoryMap.nullize(v);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new CollectionWrapper.CollectionWrapperSet(this.myMap.keySet());
    }

    public boolean removeValue(Object value) {
        Object t = ConcurrentFactoryMap.notNull(value);
        return this.myMap.values().remove(t);
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap.containsValue(ConcurrentFactoryMap.notNull(value));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new CollectionWrapper(this.myMap.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new CollectionWrapper.CollectionWrapperSet<Map.Entry<K, V>>(this.myMap.entrySet()){

            @Override
            public Object wrap(Object val) {
                return val instanceof CollectionWrapper.EntryWrapper ? ((CollectionWrapper.EntryWrapper)val).myEntry : val;
            }

            @Override
            public Map.Entry<K, V> unwrap(Map.Entry<K, V> val) {
                return val.getKey() == ConcurrentFactoryMap.FAKE_NULL() || val.getValue() == ConcurrentFactoryMap.FAKE_NULL() ? new CollectionWrapper.EntryWrapper(val) : val;
            }
        };
    }

    @NotNull
    protected ConcurrentMap<K, V> createMap() {
        return new ConcurrentHashMap();
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        return ConcurrentFactoryMap.nullize(this.myMap.putIfAbsent(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value)));
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        return this.myMap.remove(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        return this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(oldValue), ConcurrentFactoryMap.notNull(newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        return ConcurrentFactoryMap.nullize(this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value)));
    }

    public String toString() {
        return this.myMap.toString();
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(final @NotNull Function<? super T, ? extends V> computeValue) {
        return new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
    }

    @NotNull
    public static <K, V> ConcurrentMap<K, V> create(final @NotNull Function<? super K, ? extends V> computeValue, final @NotNull Supplier<? extends ConcurrentMap<K, V>> mapCreator) {
        return new ConcurrentFactoryMap<K, V>(){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }

            @Override
            @NotNull
            protected ConcurrentMap<K, V> createMap() {
                return (ConcurrentMap)mapCreator.get();
            }
        };
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createWeakMap(@NotNull Function<? super T, ? extends V> compute) {
        return ConcurrentFactoryMap.create(compute, CollectionFactory::createConcurrentWeakMap);
    }

    private static class CollectionWrapper<K>
    extends AbstractCollection<K> {
        private final Collection<K> myDelegate;

        CollectionWrapper(Collection<K> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<K> it;
                {
                    this.it = myDelegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public K next() {
                    return this.unwrap(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.myDelegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.myDelegate.contains(this.wrap(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.myDelegate.remove(this.wrap(o));
        }

        protected Object wrap(Object val) {
            return ConcurrentFactoryMap.notNull(val);
        }

        protected K unwrap(K val) {
            return (K)ConcurrentFactoryMap.nullize(val);
        }

        protected static final class EntryWrapper<K, V>
        implements Map.Entry<K, V> {
            final Map.Entry<? extends K, ? extends V> myEntry;

            private EntryWrapper(Map.Entry<? extends K, ? extends V> entry) {
                this.myEntry = entry;
            }

            @Override
            public K getKey() {
                return (K)ConcurrentFactoryMap.nullize(this.myEntry.getKey());
            }

            @Override
            public V getValue() {
                return (V)ConcurrentFactoryMap.nullize(this.myEntry.getValue());
            }

            @Override
            public V setValue(V value) {
                return (V)this.myEntry.setValue(ConcurrentFactoryMap.notNull(value));
            }

            @Override
            public int hashCode() {
                return this.myEntry.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return this.myEntry.equals(obj instanceof EntryWrapper ? ((EntryWrapper)obj).myEntry : obj);
            }
        }

        private static class CollectionWrapperSet<K>
        extends CollectionWrapper<K>
        implements Set<K> {
            CollectionWrapperSet(@NotNull Collection<K> delegate) {
                super(delegate);
            }
        }
    }
}

